import time, random, sys

#aumento il numero di ricorsioni massime
sys.setrecursionlimit(100000000)

def insertionsort(array):
	for removed_index in list(range(1, len(array))):
		removed_value = array[removed_index]
		insert_index = removed_index
		while insert_index > 0 and array[insert_index - 1] > removed_value:
			array[insert_index] = array[insert_index - 1]
			insert_index = insert_index - 1
		array[insert_index] = removed_value
	
	return array
	
def selectionsort(array):
	for i in list(range(len(array)-1)):
		m=i
		for j in list(range(i+1,len(array))):
			if array[j]<array[m]: m=j
		t = array[m]
		array[m]=array[i]
		array[i]=t
	return array

def bubblesort(seq):
	for i in list(range(len(seq)-1, 0, -1)):
		for index in list(range(i)):
			if seq[index] > seq[index + 1]:
				tmp = seq[index]
				seq[index] = seq[index+1]
				seq[index+1] = tmp
	return seq

	 
def quicksort(alist):
	quickSortHelper(alist,0,len(alist)-1)

def quickSortHelper(alist,first,last):
	if first<last:
		splitpoint = partition(alist,first,last)
		quickSortHelper(alist,first,splitpoint-1)
		quickSortHelper(alist,splitpoint+1,last)
		
def partition(alist,first,last):
	pivotvalue = alist[first]
	leftmark = first+1
	rightmark = last
	
	done = False
	while not done:
		while leftmark <= rightmark and alist[leftmark] <= pivotvalue:
			leftmark = leftmark + 1
		
		while alist[rightmark] >= pivotvalue and rightmark >= leftmark:
			rightmark = rightmark -1
		
		if rightmark < leftmark:
			done = True
		else:
			temp = alist[leftmark]
			alist[leftmark] = alist[rightmark]
			alist[rightmark] = temp

	temp = alist[first]
	alist[first] = alist[rightmark]
	alist[rightmark] = temp
	
	return rightmark
	 
lista=[]
for i in range(1000):
	lista.insert(i,random.random())
	 
start=time.clock()	 
l=insertionsort(lista)
end=time.clock()

print("tempo del insertion sort:",end-start,"\n\n")

	 
start=time.clock()	 
l=bubblesort(lista)
end=time.clock()

print("tempo del bubble sort:",end-start,"\n\n")


start=time.clock()	 
l=selectionsort(lista)
end=time.clock()

print("tempo del selection sort:",end-start,"\n\n")


start=time.clock()	 
l=quicksort(lista)
end=time.clock()

print("tempo del quick sort:",end-start,"\n\n")


start=time.clock()	 
lista.sort()
end=time.clock()

print("tempo del metodo sort nativo di python:",end-start,"\n\n")



