def leggi(nome_file):
	f = open (nome_file, 'r')
	
	libri = []
	while True:
		titolo = f.readline().strip("\n")
		if titolo == '' or titolo == '\n' :	break
		isbn = f.readline().strip("\n")
		editore = f.readline().strip("\n")
		anno = int(f.readline())
		autori = f.readline().strip("\n")
		
		# si costruisce la lista degli autori:
		a = autori.split()
		
		lista_autori = []
		for i in range(0,len(a)-1,2):
			lista_autori.append({"nome":a[i],"cognome":a[i+1]})		

		libro = { 'titolo' : titolo,'anno' : anno,'editore' : editore,'ISBN' : isbn,'autori' : lista_autori }
		libri = libri + [ libro ]
		#oppure: libri.append(libro)
	f.close()
	
	return libri
	
# si assume che nome e cognome dell'autore siano memorizzati in un dizionario,
#  avente la stessa struttura definita sopra
def libri_autore (libri, autore):

    for libro in libri:
        for aut in libro['autori']:

            # se uno degli autori corrisponde a quello cercato,
            #  si stampano le informazioni richieste
            if (aut['nome'] == autore['nome'] and aut['cognome'] == autore['cognome']):
                print(libro['titolo'])
                print(libro['anno'])

def libri_editore (libri, editore, anno1, anno2):
    for libro in libri:
        if (libro['editore'] == editore and libro['anno'] >= anno1 and libro['anno'] <= anno2):
            print(libro['titolo'])
            print(libro['ISBN'])

# memorizzare in una variabile di nome libri i dati contenuti nel file libri.txt:
libri = leggi ('libri.txt')

# stampare il titolo e il codice ISBN dei libri pubblicati da McGraw-Hill tra il 2006 e il 2010:
print("'McGraw-Hill', 2006 - 2010: ")
libri_editore (libri, 'McGraw-Hill', 2006, 2010)

# stampare il titolo e l'anno di pubblicazione dei libri di cui sia autore o coautore Stefano Ceri:
print("\nLibri di Stefano Ceri:")
libri_autore (libri,{ 'nome':'Stefano', 'cognome':'Ceri'})
