def leggi(nomeFile):
	file = open (nomeFile, 'r')
	righe = file.readlines()
	file.close()
	comandi = []
	
	for riga in righe:
		comando = {}	
		riga = riga.split()
		comando["direzione"] = riga[0].upper()
		comando["metri"] = riga[1]
		comandi.append(comando)

	return comandi
	
def elabora(comandi):
	x = 0
	y = 0
	posizioneFinale = []
	for comando in comandi: 
		direzione = comando["direzione"].upper()
		spostamento = int(comando["metri"])
		if direzione == "NORD": y = y + spostamento
		if direzione == "SUD": y = y - spostamento
		if direzione == "EST": x = x + spostamento
		if direzione == "OVEST": x = x - spostamento
	
	if y<0: 
		direzioneY = "SUD"
	else:
		direzioneY = "NORD"
	posizioneFinale.append({"direzione":direzioneY,"metri":abs(y)})
	
	if x<0: 
		direzioneX = "OVEST"
	else:
		direzioneX = "EST"
	posizioneFinale.append({"direzione":direzioneX,"metri":abs(x)})
	
	return posizioneFinale
	
def stampa(posizioneFinale):
	for coordinata in posizioneFinale:
		print(str(coordinata["metri"]) + " METRI VERSO " + coordinata["direzione"])
		
def inverti(coordinata):
	if coordinata.upper() == "NORD": return "SUD"
	if coordinata.upper() == "SUD": return "NORD"
	if coordinata.upper() == "EST": return "OVEST"
	if coordinata.upper() == "OVEST": return "EST"
	return -1
	
def scrivi(nomeFile,posizioneFinale):
	file = open (nomeFile, 'a')
	file.write("\n\n")
	for coordinata in posizioneFinale:
		direzione = coordinata["direzione"]
		metri = str(coordinata["metri"])
		file.write(inverti(direzione)+" "+metri+"\n")
	file.close()
	
comandi = leggi("comandi.txt")
posizioneFinale = elabora(comandi)
stampa(posizioneFinale)
scrivi("comandi.txt", posizioneFinale)


