import time

def leggi(nomeFile):
	file = open (nomeFile, 'r')
	righe = file.readlines()
	file.close()
	prenotazioni = []
	
	for riga in righe:
		prenotazione = {}	
		riga = riga.split()
		prenotazione["cognome"] = riga[0].lower()
		prenotazione["priorita"] = int(riga[1])
		prenotazione["data"] = int(riga[2])
		prenotazioni.append(prenotazione)

	return prenotazioni
	
def raggruppaPerPriorita(priorita, prenotazioni):
	pazienti=[]
	for prenotazione in prenotazioni:
		if prenotazione["priorita"] == int(priorita): pazienti.append(prenotazione["cognome"])
	
	return pazienti

def bubblesort(seq):
	for i in list(range(len(seq)-1, 0, -1)):
		for index in list(range(i)):
			if str(seq[index]["cognome"]) > str(seq[index + 1]["cognome"]):
				tmp = seq[index]
				seq[index] = seq[index+1]
				seq[index+1] = tmp
	
	
def organizzaAppuntamenti(prenotazioni):
	inviti = open ("inviti.txt", 'w')
	day = 1
	for priorita in range(1,5):
		cognomi=raggruppaPerPriorita(priorita, prenotazioni)
		for cognome in cognomi:
			inviti.write(cognome + " " + str(priorita) + " " +str(day)+"\n")
			day=day+1
	inviti.close()
	
def stampa(lista):
	for elemento in lista:
		print (elemento["cognome"], " ", elemento["priorita"], " ", elemento["data"])

def ricercaGiornoLibero(giorno,seq):
	left = 0
	right = len(seq)-1
	while left<=right:
		center = int((int(left) + int(right)) / 2)
		if giorno<seq[int(center)]["data"]:
			right=center-1
		elif giorno>seq[int(center)]["data"]:
			left=center+1
		else:
			return center
	return -1

	
prenotazioni=leggi("pazienti.txt")

start=time.clock()
bubblesort(prenotazioni)
end=time.clock()
print("il tempo di esecuzione di bubblesort è: ",end-start)

stampa(prenotazioni)

organizzaAppuntamenti(prenotazioni)

data=int(input("inserisci un giorno:"))
prenotazioni=leggi("inviti.txt")

libero=ricercaGiornoLibero(data, prenotazioni)
if libero>=0:
	print("il giorno è occupato")
else:
	print("il giorno è libero")
		