<?xml version="1.0" encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">

<xsl:output method="html" indent="yes" 
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" />

<xsl:template match="/">

<html  xmlns="http://www.w3.org/1999/xhtml">

<head>
<title>XML-blog</title>

<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />

<link rel="stylesheet" title="main" href="fogliostile.css" type="text/css" />
</head>
<!-- Fine della testata-->

<!-- Inizia il corpo del documento-->
<body>
<!-- Questa parte  identica al documento blog.xhtml". E' la parte fissa del documento-->
<div id="sezprinc">

<div id="testata"><img src="logo.jpg" width="165" height="65"
alt="logo Corso" /></div>
<div id="menu">
<p><a href="#">home page</a> - <a href="#">about</a> - <a href="#">archivi</a>

- <a href="#">contatti</a> -------------------- <a href="#">e-m@il me</a></p>
</div>
<div id="contenuto">

<div id="navigazione">
<h1>sezione 1</h1>
<p><a href="#">link 1</a></p>
<p><a href="#">link 2</a></p>
<p><a href="#">link 3</a></p>

<h1>sezione 2</h1>
<p><a href="#">link 1</a></p>
<p><a href="#">link 2</a></p>
<p><a href="#">link 3</a></p>
</div>
<!-- Fine della parte fissa del documento-->

<!-- Inizia la sezione "post". Il contenuto  preso dal file "news.xml"-->
<div id="post">

<!-- Selezioniamo l'elemento <post>. Le regole sono applicate in maniera ricorsiva-->
<xsl:for-each select="news/post">

<!-- Ordiniamo i post per data-->
	<xsl:sort data-type="text" select="data" order="descending"/>

<!-- Il testo dell'elemento <data> sar un titolo <h2>-->
<h1><xsl:value-of select="titolo" /></h1>

<!-- Il testo dell'elemento <titolo> sar un titolo <h1>-->
<h2><xsl:value-of select="titolo"/></h2>

<!-- Applichiamo il template. Il testo dei post sar un paragrafo-->
<p><xsl:apply-templates select="testo"/></p>	
</xsl:for-each>
</div>
</div>
</div>
</body>

<!-- Fine del corpo del documento XHTML-->
</html>
</xsl:template>

<!-- Dichiariamo il template per la gestione dei link-->
<xsl:template match="link">
     <xsl:element name="a">
       <xsl:attribute name="href">
        <xsl:value-of select="@href"/>
       </xsl:attribute>
        <xsl:apply-templates/>
     </xsl:element>

  </xsl:template>

</xsl:stylesheet>