<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:variable name="books_by_rh"
	select="//book[author-ref/@ref='rh']"/>
<xsl:variable name="more_than_one_auth"
	select="//book[count(author-ref) &gt; 1]"/>
<xsl:template match="/">
	Total number of books by Robert Heinlein: 
	<xsl:value-of select="count($books_by_rh)" />
	Total number of books by several authors: 
	<xsl:value-of select="count($more_than_one_auth)" />
	Number of books in the union of the two sets
	<xsl:value-of select="count($books_by_rh | 
		$more_than_one_auth)"/>
</xsl:template>
</xsl:stylesheet>
