import sys
import argparse

from Conferenza import Conferenza
from Partecipazione import Partecipazione
from Partecipante import Partecipante
from Regolare import Regolare
from Studente import Studente


class Gestione:
    def __init__(self, arg):
        self._arg = arg

    def main(self):
        partecipanti = []
        conferenze = []
        codPart = {}

        try:
            f = open("partecipanti.txt", "r")
            line = f.readline().strip()
            while(line != ''):
                tok = line.split()
                cod = int(tok[0])
                tipo = tok[1]
                nome = f.readline().strip()
                cognome = f.readline().strip()

                if(tipo == "studente"):
                    corso = f.readline().strip()
                    uni = f.readline().strip()
                    line = f.readline().strip()
                    anno = int(line)
                    s = Studente(cod, nome, cognome, corso, uni, anno)
                    partecipanti.append(s)
                    codPart[cod] = s
                else:
                    ente = f.readline().strip()
                    line = f.readline().strip()
                    tok = line.split()
                    dip = int(tok[0])
                    acc = bool(tok[1])
                    r = Regolare(cod, nome, cognome, ente, dip, acc)
                    partecipanti.append(r)
                    codPart[cod] = r

                line = f.readline().strip()
            f.close()
        except IOError as i:
            print(i)
        except Exception as e:
            print(e)

        try:
            f = open("conferenze.txt", "r")
            line = f.readline().strip()
            while(line != ''):
                nome = line
                luogo = f.readline()
                c = Conferenza(nome, luogo)
                conferenze.append(c)
                line = f.readline()
                while(line != "\n"):
                    tok = line.split()
                    cod = int(tok[0])
                    reg = int(tok[1])
                    p = codPart[cod]
                    part = Partecipazione(p, reg)
                    c.addPart(part)
                    line = f.readline()
                line = f.readline().strip()
            f.close()
        except IOError as i:
            print(i)

        print("tipo, codice, nome, cognome, corso di studi, università, anno di corso, ente di appartenenza, numero di dipendenti, accademico\n")

        for p in partecipanti:
            print(p.toString())

        print("\n")

        for c in conferenze:
            print(c.toString())

        print("\n")

        try:
            p = codPart[int(self._arg)]
            if(str(p.getTipo()) == "studente"):
                s = p
                print("Studente, università: " + s.getUni())
            else:
                r = p
                print("Regolare, ente: " + r.getEnte())
        except IOError as i:
            print(i)


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('partecipante', action='store')
    pa = parser.parse_args()
    g = Gestione(pa.partecipante)
    g.main()
