
####### uso degli istogrammi in R

##### libreria per fit di distribuzioni
library(MASS)


##### generiamo dei dati casuali distribuiti secondo una gaussiana
mediateo=5
sigmateo=2

dati <- rnorm(1000, mediateo, sigmateo)

mean(dati)
sd(dati)

###### gli stessi risultati si ottengono eseguendo il fit con distribuzione normale
###### eseguiamo il fit

datifit <- fitdistr(dati, "normal")

mediafit <- coef(datifit)[1]
sigmafit <- coef(datifit)[2]

###### l'oggetto datifit non fornisce informazioni sul chi quadro, perche' questo dipende dal numero di classi
###### analizziamo quindi in dettaglio l'uso degli istogrammi

par(mfrow=c(1,2))

###### confrontiamo le due rappresentazioni dello stesso istogramma

###### istogramma con le frequenze
hist(dati, freq = TRUE, nclass = 20)

###### istogramma con le densita' (Area dell'istogramma = 1)
hist(dati, freq = FALSE, nclass = 20)

counts = hist(dati, freq = FALSE, nclass = 20)$counts
dens = hist(dati, freq = FALSE, nclass = 20)$density

##### e' il numero totale di dati
sum(counts)

#### non e' necessariamente uguale a 1, in quanto dipende dalla larghezza delle classi
#### l'area dell'istogramma e' normalizzata a 1
sum(dens)

#### per ottenere 1 si deve moltiplicare per la larghezza delle classi

#### otteniamo gli estemi delle classi
breaks = hist(dati, freq = FALSE, nclass = 20)$breaks

#### calcoliamo la larghezza di una classe
DeltaX = breaks[2] - breaks[1]

##### area dell'istogramma = 1
sum(dens)*DeltaX




######## alcune considerazioni sulle classi negli istogrammi
######## contando le classi e' evidente che l'opzione nclass = xx non
######## imposta sempre esattamente il numero di classi richiesto, ma un numero prossimo
######## questo va bene per una visualizzazione rapida degli istogrammi

par(mfrow=c(2,2))

hist(dati, freq = TRUE, nclass = 4)
hist(dati, freq = TRUE, nclass = 10)
hist(dati, freq = TRUE, nclass = 20)
hist(dati, freq = TRUE, nclass = 40)

####### er fissare sistematicamente un numero di classi
####### bisogna definire gli estremi delle classi con l'opzione breaks

## definiamo quindi

classi = 30
minimo = -5
massimo = 15

estremi = 0

for (k in 1:(classi+1)) {
    estremi[k] = minimo + (k-1)*((massimo-minimo)/classi)
}

#### se le classi sono N il numero di estremi sara' N+1

par(mfrow=c(1,1))

hist(dati, freq = FALSE, breaks = estremi)

#### sovrapponiamo all'istogramm delle densita'
#### la gaussiana normalizzata a 1 con parametri ottenuti dal fit

curve((1/(sigmafit*sqrt(2*3.14)))*exp(((x-mediafit)^2)/(-2*(sigmafit^2))), from = -5, to = 15, add = T, col = 2, lwd = 4)



######### cenni al calcolo del chi2
#### l'area di ogni classe deve esere confrontata con l'area della gaussiana (integrale)
#### fra gli estremi della classe

#### R mette a disposizione una funzione per il calcolo dell'area della gaussiana da
#### -infinito ad un estremo fissato

#### per esempio, se la media e' circa 5, l'integrale fino a 5 e' 1/2

pnorm(5, mediafit, sigmafit, lower.tail = T)


