#
# simuliamo dei dati misurati con dipendenza lineare, quindi
#
# supponiamo che la misura sia su y, quindi x sara' impostato da noi

x <- c(1:10)
     
# definiamo coefficiente angolare e intercetta:
Ateo <- c(2)
Bteo <- c(3)

y= Ateo * x + Bteo

# se grafichiamo y in funzione di x notiamo che i punti sono perfettamente 
# allineati, ovvio per come gli abbiamo costruiti

plot(x,y)

# vogliamo quindi che non siano perfettamente allineati, al fine di simulare 
# dei dati misurati

# costruiamo quindi un vettore ymis = y + (un numero random)
#
# generiamo 10 numeri random 

ErrSim <- rnorm(10, 0, 0.5)

# quindi costruiamo ymis

ymis=y+ErrSim



######### regressione lineare
### calcolo di A (coefficiente angolare) e B (termine noto)

N = length(x)
D = N * sum(x^2) - sum(x)^2

A = (N*sum(x*ymis) - sum(x)*sum(ymis))/D
B = (sum(ymis)*sum(x^2) - sum(x)*sum(x*ymis))/D



plot(x,ymis, pch = 16)
curve(A * x + B , add=T, col = 2)



######## calcoliamo coeff correlazione lineare

rNum = sum( (x-mean(x)) * (ymis-mean(ymis)) )

rDen = sqrt( sum( (x-mean(x))^2 )* sum( (ymis-mean(ymis))^2 )  )

r = rNum/rDen


yteo = A*x+B

chi2 = sum( (ymis-yteo)^2 )

chi2rid = chi2/8




############### fit linear model


fitlm <- lm(ymis ~ x)


###### stampiamo a video tutte le informazioni del fit
summary(fitlm)

plot(x,ymis)
curve(coef(fitlm)[2]*x+coef(fitlm)[1], add=T, col = 2)


############# fit linear model pesi


symis = abs(ErrSim)

w= 1/symis^2


##### libreria per fare i grafici con le barre di errore
library(sfsmisc)


errbar(x,ymis,ymis+symis,ymis-symis, pch = 16)


fitlmW <- lm(ymis ~ x, weights = w)


curve(coef(fitlmW)[2]*x+coef(fitlmW)[1], add=T, col = 2)
curve(coef(fitlm)[2]*x+coef(fitlm)[1], add=T, col = 4)

# summary(fitlm)  contiene anche il Residual Standard Error che e' la radice quadrata del chi quadro ridotto
# per estrarre solo questo numero

chi2ridFit = (summary(fitlm)$sigma)^2


################ fine lezione R 24/11/2014







x <- c(1:10)
Ateo <- c(2)
Bteo <- c(3)
my_func <- function(A,B,xx){ yy = A*xx+B ;return(yy)}
y = my_func(Ateo, Bteo, x)
ErrSim <- rnorm(10, 0, 0.5)
ymis=y+ErrSim
N = length(x)
D = N * sum(x^2) - sum(x)^2
A = (N*sum(x*ymis) - sum(x)*sum(ymis))/D
B = (sum(ymis)*sum(x^2) - sum(x)*sum(x*ymis))/D
plot(x,ymis, pch = 16)
curve(A * x + B , add=T, col = 2)
yteo = A*x+B
chi2 = sum( (ymis-yteo)^2 )
chi2rid = chi2/(N-2)




