

###### metodo dei minimi quadrati su variabili che non hanno dipendenza lineare


library(sfsmisc)

##### costruiamo le solite x ymis simulate, secondo una retta

x <- c(1:10)

Ateo <- c(2)
Bteo <- c(3)

y= Ateo * x + Bteo

ErrSim <- rnorm(10, 0, 0.5)

ymis=y+ErrSim

symis = abs(ErrSim)

w= 1/symis^2



############################################
# lm si usa solo per variabili che hanno una dipendenza lineare.
# se le variabili non hanno un dipendenza lineare si puo' usare il
# comando nls = non-linear last square

fitnls <- nls(ymis ~ Amis * x + Bmis, start = list(Amis = 1, Bmis = 1), weights=w)

# visualizziamo i risultati ottenuti

summary(fitnls)


### costriamo le y fittate

yfit = coef(fitnls)[1]*x + coef(fitnls)[2]


chi2rid = (summary(fitnls)$sigma)^2

## visualizziamo il grafico

errbar(x,ymis,ymis+symis,ymis-symis, pch = 16)
curve(coef(fitnls)[1]*x+coef(fitnls)[2], add=T)


#############################################

# proviamo con altro esempio, questa volta 
# ipotizziamo un andamento esponenziale decrescente
# y = A2teo * exp(-B2teo*x) + C2teo

A2teo = 5
B2teo = 0.3
C2teo = 0

y2= A2teo * exp(-B2teo*x) + C2teo

ErrSim2 <- rnorm(10, 0, 0.2)

w2 = 1/ErrSim2^2

y2mis = y2 + ErrSim2

datifit <- nls(y2mis ~ A2mis * exp(-B2mis*x) + C2mis, start = list(A2mis = 1, B2mis = 0.1, C2mis=0.1), weights=w2)

######################
# un modo migliore per visualizzare dati e funzione fittata  questo

errbar(x,y2mis,y2mis+abs(ErrSim2),y2mis-abs(ErrSim2), pch = 16)
curve(coef(datifit)[1] * exp(-coef(datifit)[2]*x) + coef(datifit)[3], add=T, col = 2)

# stampiamo il chi2 ridotto

(summary(datifit)$sigma)^2




