
####### uso degli istogrammi in R

##### libreria per fit di distribuzioni
library(MASS)


##### generiamo dei dati casuali distribuiti secondo una gaussiana
mediateo=5
sigmateo=2
dati <- rnorm(1000, mediateo, sigmateo)

mean(dati)
sd(dati)

###### gli stessi risultati si ottengono eseguendo il fit con distribuzione normale
###### eseguiamo il fit

datifit <- fitdistr(dati, "normal")
mediafit <- coef(datifit)[1]
sigmafit <- coef(datifit)[2]

###### l'oggetto datifit non fornisce informazioni sul chi quadro, perche' questo dipende dal numero di classi
###### analizziamo quindi in dettaglio l'uso degli istogrammi



## definiamo quindi

classi = 30
minimo = -5
massimo = 15

##### modo diverso per calcolare gli estremi, anziche' usare il ciclo for

estremi <- seq(from = minimo, to = massimo, by = ((massimo-minimo)/classi))

#### proviamo anche con 10 classi
estremi10 <- seq(from = minimo, to = massimo, by = ((massimo-minimo)/10))


###### per confrontare istogramma e gaussiana fittata plottiamo sempre l'instogramma delle densita',
###### in questo modo abbiamo sempre istogramma e gaussiana normalizzati a 1 (area = 1)

par(mfrow=c(1,2))

hist(dati, freq = FALSE, breaks = estremi)

curve((1/(sigmafit*sqrt(2*3.14)))*exp(((x-mediafit)^2)/(-2*(sigmafit^2))), from = -5, to = 15, add = T, col = 2, lwd = 4)

hist(dati, freq = FALSE, breaks = estremi10)

curve((1/(sigmafit*sqrt(2*3.14)))*exp(((x-mediafit)^2)/(-2*(sigmafit^2))), from = -5, to = 15, add = T, col = 2, lwd = 4)


par(mfrow=c(1,1))

######### calcolo del chi2
#### l'area di ogni classe deve esere confrontata con l'area della gaussiana (integrale)
#### fra gli estremi della classe

#### R mette a disposizione una funzione per il calcolo dell'area della gaussiana da
#### -infinito ad un estremo fissato

#### per esempio, se la media e' circa 5, l'integrale fino a 5 e' 1/2

pnorm(5, mediafit, sigmafit, lower.tail = T)

###### il chi2 si calcola con la nota formula
#### chi2 = Somma( (O_k - E_k)^2 / E_k  )
#### chi2rid = chi2/ndf    ndf = Nclassi - Npar    Npar = 2


###### frequenze Osservate di ogni classe

O = 0
O <- (hist(dati, freq = TRUE, breaks = estremi)$counts)

#### Expected calcolati con la gaussiana normalizzata a 1

O = 0
O <- (hist(dati, freq = TRUE, breaks = estremi)$counts)

Enorm = 0
for (i in 1:(length(estremi)-1)) {
    Enorm[i] = pnorm(estremi[i+1], mediafit, sigmafit, lower.tail = T) - pnorm(estremi[i], mediafit, sigmafit, lower.tail = T)
}

E = Enorm*sum(O)
ndf = length(O)-2
chi2 = sum(((O-E)^2)/E)
chi2rid = chi2/ndf

#### Expected calcolati con la gaussiana normalizzata al numero totale di misure
E = Enorm*sum(O)

ndf = length(O)-2

chi2 = sum(((O-E)^2)/E)
chi2rid = chi2/ndf

#### oppure usiamo le densita'

Od = 0
Od <- (hist(dati, breaks = estremi)$density)*(estremi[2] - estremi[1])

chi2d = 1000*sum(((Od - Enorm)^2)/Enorm)
chi2drid = chi2d/ndf




pchisq(chi2, ndf, lower.tail = F)
chisq.test(O, p = E, rescale.p = T)



########## scansione di chi2 al variare di nclassi

classi = 0
classi <- c(5,10,20,30,40,50,60,70,80,90,100,200,300,400,500,600,700,800,1000)

minimo = -5
massimo = 15

chi2ridscan = 0
pchiscan = 0

for (j in 1:length(classi)) {

    estremi = 0
    estremi <- seq(from = minimo, to = massimo, by = ((massimo-minimo)/classi[j]))

    O = 0
    O <- (hist(dati, breaks = estremi)$counts)

    Enorm = 0
    for (i in 1:(length(estremi)-1)) {
        Enorm[i] = pnorm(estremi[i+1], mediafit, sigmafit, lower.tail = T) - pnorm(estremi[i], mediafit, sigmafit, lower.tail = T)
    }
    E = 0
    E = Enorm*sum(O)
    ndf = length(O)-2
    
    chi2 = sum(((O-E)^2)/E)
    chi2ridscan[j] = chi2/ndf
    pchiscan[j] = pchisq(chi2, ndf, lower.tail = F)

}

## Ricalcoliamo con 40 classi
minimo = -5
massimo = 15
estremi <- seq(from = minimo, to = massimo, by = ((massimo-minimo)/40))

pdf("~/Documents/Didattica/2014 2015/LaboratorioLuppi/esercitazione R/Lezioni_R/GaussFit.pdf")

hist(dati, freq = FALSE, breaks = estremi)
curve((1/(sigmafit*sqrt(2*3.14)))*exp(((x-mediafit)^2)/(-2*(sigmafit^2))), from = -5, to = 15, add = T, col = 2, lwd = 4)


plot(classi,chi2ridscan, type = "l", ylim = c(0,1.2))
points(classi,pchiscan, type = "l", col = 2)

plot(chi2ridscan,pchiscan)
plot(subset(chi2ridscan, classi > 10),subset(pchiscan, classi>10))

dev.off()






