

#include <EEPROM.h>

int state = 0;
String comString;

unsigned long int startTime;
unsigned long int sleepTime = 1000; /// lavoriamo in ms
bool ledState = false;

int myPinLed = 3;


void setup() {
  // put your setup code here, to run once:

   
  Serial.begin(9600);
  while (!Serial) {};
  Serial.println("start_tc_measurement");

  readsetup();

  state = 1;

  
  pinMode(myPinLed, OUTPUT);
  startTime = millis();

}

void loop() {


  SerialListen();
  if (state == 1) runBlink(); 
  if (state == 2) setTime();




}



//////// funzione di blink quando siamo in state = 1

void runBlink()
{
    if ( (millis() - startTime) >= sleepTime ) /// controlliamo se e' scaduto il tempo di sleep
  { 
    ledState = !ledState;
    digitalWrite(myPinLed, ledState);
    startTime = millis();
    Serial.println(String("Pin change state to = ") + String(ledState));
  }

}


///// funzione readSetup per leggere la EEPROM

///// read Nmeas from EEPROM
void readsetup() {


  Serial.println(String("Read EEPROM cell 0 - 1 = ") + String(EEPROM.read(0)) + String(" - ") + String(EEPROM.read(1)));

  sleepTime = 100*EEPROM.read(1) + EEPROM.read(0);
  if (sleepTime == 0) sleepTime = 500;
  
  comString = "";
  state = 1; 

}


//////// funzione setTime

void setTime() {

  sleepTime = comString.substring(4).toInt();
  
  Serial.println(String("Set sleepTime to = ") + String(sleepTime));

  EEPROM.write(0, sleepTime - (sleepTime/100)*100);
  EEPROM.write(1, sleepTime/100);

  
     
  comString = "";
  state = 1; 

}



//////// Serial command listening and parsing

void SerialListen() {
  
  comString = "";
  
  if (Serial.available() > 0) {  
    
    delay(10);
    bool stringComplete;
    stringComplete = false;
  
    while (!stringComplete) {
      char inChar = (char)Serial.read(); 
      comString += inChar;
       if (inChar == '\n')  stringComplete = true;
     }

     Serial.println(String("Command received = ") + comString);

     if (comString.startsWith("stop")) state = 0;
     if (comString.startsWith("run")) state = 1;
     if (comString.startsWith("set")) state = 2;

  }
  //Serial.println(command);
  //if (command.startsWith("setfun")) Serial.println("Set Function");
  
}

/////////////










