import socket
import time
from threading import Thread

UDP_IP = "127.0.0.1"
UDP_PORT = 5005
bufflen = 8192
pixnum = 512

sock = socket.socket(socket.AF_INET, # Internet
                     socket.SOCK_DGRAM) # UDP


print("UDP target IP:", UDP_IP)
print("UDP target port:", UDP_PORT)


dataRef = bytearray(0)
print("DataRef init ",dataRef)
index = 0
for i in range(0,pixnum):
     num = 0
     for j in range(0,pixnum):
        num0 = num & 0x00FF
        num1 = (num >> 8) & 0x00FF
        numarr = [num1,num0]
        dataRef += bytearray(numarr)
        #print("Compose ",i," ",j)
        num = num + 1
        
print("Length of data = ", len(dataRef))



nstep = int(len(dataRef)/bufflen) + (len(dataRef)%bufflen != 0)
starttime = time.time()
nmsg = 0
while True:
    index = 0
    for i in range(0,nstep):
        index = i*bufflen
        sock.sendto(dataRef[index:(index+bufflen+1)], (UDP_IP, UDP_PORT))
        time.sleep(0.0001)
    ### rotate data
    dataRef = dataRef[2:(len(dataRef)+1)] + dataRef[0:2]
    nmsg += 1
    #time.sleep(1)
    if (nmsg%100 == 0): print("Message sent (ms)", nmsg, 1000*(time.time()-starttime))

stoptime = time.time()
deltaT = 1000*(stoptime-starttime)

print("Message sent (ms)", deltaT)
sock.close()

