
int state = 0;
String comString;

unsigned long int measTime;
unsigned long int sleepTime = 1000; /// lavoriamo in ms

int measmin = 0;
int measmax = 100;

int meas = 0;

/////// codice eseguito all'avvio del microcontrollore
void setup() {
  // put your setup code here, to run once:

  Serial.begin(9600);
  while (!Serial) {};
  //Serial.println("start_arduino_measurement");

  measTime = millis();

}


/////// codice eseguito in loop dal microcontrollore
void loop() {

  SerialListen();
  if (state == 1) getMeas(); 

}



//////// funzione di blink quando siamo in state = 1

void getMeas()
{
  if ( (millis() - measTime) >= sleepTime ) /// controlliamo se e' scaduto il tempo di sleep
  { 
    meas = random(measmin,measmax);
    measTime = millis();
    Serial.println(String("MEAS ") + String(measTime) + String(" ") + String(meas));
  }

}


//////// funzione setTime

void setTime() {
  
  int index1 = 0;
  index1 = comString.indexOf(" ", 0);

  sleepTime = comString.substring(index1).toInt();
  
  Serial.println(String("Set sleepTime to = ") + String(sleepTime));
     
  comString = "";
  state = 0; 

}

//////// funzione setTime

void setRange() {

  int index1 = 0;
  int index2 = 0;

  index1 = comString.indexOf(" ", 0);
  index2 = comString.indexOf(" ", (index1 + 1));

  measmin = comString.substring(index1,index2).toInt();
  measmax = comString.substring(index2).toInt();
  
  Serial.println(String("Set range to = ") + String(measmin) + String(" ") + String(measmax));
     
  comString = "";
  state = 0; 



}


//////// Serial command listening and parsing

void SerialListen() {
  
  comString = "";
  
  if (Serial.available() > 0) {  
    
    delay(10);
    bool stringComplete;
    stringComplete = false;
  
    while (!stringComplete) {
      char inChar = (char)Serial.read(); 
      if (isAscii(inChar)) comString += inChar; //// elimina caratteri non ascii
      if (inChar == '\n')  stringComplete = true;
     }

     //Serial.println(String("Command received = ") + comString + String(" ") + String(comString.length()));

     if (comString.startsWith("stop")) state = 0;
     if (comString.startsWith("run")) state = 1;
     if (comString.startsWith("getmeas")) getMeas();
     if (comString.startsWith("settime")) setTime();
     if (comString.startsWith("setrange")) setRange();

  }
  //Serial.println(command);
  //if (command.startsWith("setfun")) Serial.println("Set Function");
  
}

/////////////
