from guizero import *

import serial
from serial.serialutil import SerialException
from serial.tools import list_ports


enableGetCount = 0

def connect():
    try:
        ser.open()
        ser.write("reset\r\n".encode())
    except SerialException:
        alerts.error(app, "No Connection! Unplug device")

def disconnect():
    ser.close()



def up(tw):
    num = int(tw.value)+1
    if num > 9 : num = 0
    tw.value = str(num)
    return;


def down(tw):
    num = int(tw.value)-1
    if num < 0 : num = 9
    tw.value = str(num)

    return;


def count_down():
    num = int(countdown_ind.value)
    if num > 0:
        time_string = str(num-100)
        countdown_ind.value = time_string
        t0_d.value = time_string[0]
        if len(time_string) > 1 : t1_d.value = time_string[1]
        if len(time_string) > 2 : t2_d.value = time_string[2]
        if len(time_string) > 3 : t3_d.value = time_string[3]
        if len(time_string) > 4 : t4_d.value = time_string[4]
        if len(time_string) > 5 : t5_d.value = time_string[5]
        return

def start_counter():
    global enableGetCount
    gate_time = int(t0_in.value) + 10*int(t1_in.value) + 100*int(t2_in.value) + 1000*int(t3_in.value) + 10000*int(t4_in.value) + 100000*int(t5_in.value)
    string_to_write = str("send ") + str(gate_time) + str('\n')
    ##print (string_to_write)
    command_to_send_bytes = string_to_write.encode()
    try:
        ser.write(command_to_send_bytes)
        enableGetCount = 1
    except SerialException:
        alerts.error(app, "Could not Send. Connected?")
        enableGetCount = 0
    return


def get_counter():
    global enableGetCount
    if (enableGetCount > 0) :
        command_to_send_bytes = str("get\n").encode()
        try:
            ser.write(command_to_send_bytes)
        except SerialException:
            alerts.error(app, "Could not Send. Connected?")
        countstring = ""
        try:
            countstring = ser.readline()
            ##print (countstring)
            stringlist = countstring.split( )
            countdown_ind.value = stringlist[1]
            countdown_real.value = stringlist[2]
            counter0_msg.value = stringlist[3]
            counter1_msg.value = stringlist[4]
            counter2_msg.value = stringlist[5]
            counter3_msg.value = stringlist[6]
            enableGetCount = int(stringlist[1])
            ##print (enableGetCount)
        except SerialException:
            alerts.error(app, "Could not Read. Connected?")
    return



"""
send_data()
run when send_button is clicked. Gets data from faces_to_send_list
and writes to serial port as bytes

1. .get selected face from faces_to_send_list
2. convert to bytes
3. .write to serial port

Alternatively, 1 + 2 + 3 all on the same:
ser.write((faces_to_send_list.get() + '\r').encode())
"""

def get_data():
    rv = ""
    command_to_send = "get\n"
    command_to_send_bytes = command_to_send.encode()
    try:
        ser.write(command_to_send_bytes)
    except SerialException:
        alerts.error(app, "Could not Send. Connected?")
    try:
            counter_message.value = ser.readline()
    except SerialException:
        alerts.error(app, "Could not Read. Connected?")



def send_sim():
    rv = ""
    command_to_send = "send 1000\n"
    command_to_send_bytes = command_to_send.encode()
    try:
        ser.write(command_to_send_bytes)
    except SerialException:
        alerts.error(app, "Could not Send. Connected?")
    try:
        counter0_msg.value = ser.readline()
    except SerialException:
        alerts.error(app, "Could not Read. Connected?")    


"""
    while True:
        ch = ser.read()
        rv += ch.decode()
        print(rv)
        if ch=='\r' or ch=='\n' or ch=='':
            print("terminazione trovata")
            counter_message.value = rv
            break
"""
"""
find_microbit_comport()
returns COM port / device the microbit is attached to.

For each com port on the computer, check whether the
attached device's product ID and vendor ID match
the microbits.
"""

def find_microbit_comport():
    ports = list(list_ports.comports())
    for p in ports:
        if (p.pid == 516) and (p.vid == 3368):
            return str(p.device)

# Main Program Begins

# serial ports
ser = serial.Serial(port="/dev/tty.usbmodem143101", baudrate=9600, timeout=10.0)
#ser.baudrate = 115200
#ser.port = find_microbit_comport()


# Window setup
app = App(layout='grid',
          height='480',
          width='720',
          title="Arduino Counter",
          bg="moccasin")
space0 = Text(app, grid=[0,0], text="", size=3)

cnt0_label = Text(app, grid=[1,0], align="right", text="CNT 0   ", size=40)
Text(app, grid=[1,1], text="", size=3)
cnt1_label = Text(app, grid=[1,2], align="right", text="CNT 1   ", size=40)
Text(app, grid=[1,3], text="", size=3)
cnt2_label = Text(app, grid=[1,4], align="right", text="CNT 2   ", size=40)
Text(app, grid=[1,5], text="", size=3)
cnt3_label = Text(app, grid=[1,6], align="right", text="CNT 3   ", size=40)
Text(app, grid=[1,7], text="", size=3)

counter0_msg = Text(app, grid=[2,0], align="right", color="#FFFFff", bg="#0099ff", text="000", size=40)
counter0_msg.height = 1
counter0_msg.width = 12
Text(app, grid=[2,1], text="", size=3)
counter1_msg = Text(app, grid=[2,2], align="right", color="#FFFFff", bg="#0099ff", text="000000000000", size=40)
counter1_msg.height = 1
counter1_msg.width = 12
Text(app, grid=[2,3], text="", size=3)
counter2_msg = Text(app, grid=[2,4], align="right", color="#FFFFff", bg="#0099ff", text="000000000000", size=40)
counter2_msg.height = 1
counter2_msg.width = 12
Text(app, grid=[2,5], text="", size=3)
counter3_msg = Text(app, grid=[2,6], align="right", color="#FFFFff", bg="#0099ff", text="000000000000", size=40)
counter3_msg.height = 1
counter3_msg.width = 12
Text(app, grid=[2,7], text="", size=3)
#counter0_msg = Text(face_box, text="counter wait")

start_butt = PushButton(app, grid=[0,0,1,8], text="START", command=start_counter)


##### box timer
timer_box = Box(app, grid=[0, 8, 3, 1], layout="grid")

t0_in = Text(timer_box, grid=[5,1], align="right", color="orange", bg="#0099ff", text="0", size=40)
t1_in = Text(timer_box, grid=[4,1], align="right", color="orange", bg="#0099ff", text="0", size=40)
t2_in = Text(timer_box, grid=[3,1], align="right", color="orange", bg="#0099ff", text="0", size=40)
t3_in = Text(timer_box, grid=[2,1], align="right", color="orange", bg="#0099ff", text="0", size=40)
t4_in = Text(timer_box, grid=[1,1], align="right", color="orange", bg="#0099ff", text="0", size=40)
t5_in = Text(timer_box, grid=[0,1], align="right", color="orange", bg="#0099ff", text="0", size=40)

t0_butt_up = PushButton(timer_box, grid=[5,0], text="+", command=up, args = [t0_in])
t1_butt_up = PushButton(timer_box, grid=[4,0], text="+", command=up, args = [t1_in])
t2_butt_up = PushButton(timer_box, grid=[3,0], text="+", command=up, args = [t2_in])
t3_butt_up = PushButton(timer_box, grid=[2,0], text="+", command=up, args = [t3_in])
t4_butt_up = PushButton(timer_box, grid=[1,0], text="+", command=up, args = [t4_in])
t5_butt_up = PushButton(timer_box, grid=[0,0], text="+", command=up, args = [t5_in])

t0_butt_down = PushButton(timer_box, grid=[5,2], text="-", command=down, args = [t0_in])
t1_butt_down = PushButton(timer_box, grid=[4,2], text="-", command=down, args = [t1_in])
t2_butt_down = PushButton(timer_box, grid=[3,2], text="-", command=down, args = [t2_in])
t3_butt_down = PushButton(timer_box, grid=[2,2], text="-", command=down, args = [t3_in])
t4_butt_down = PushButton(timer_box, grid=[1,2], text="-", command=down, args = [t4_in])
t5_butt_down = PushButton(timer_box, grid=[0,2], text="-", command=down, args = [t5_in])

countDownBox = Box(timer_box, grid=[6,0,1,3], layout="grid")

Text(countDownBox, grid=[0,0,1,3], text="", size=3)
countdown_ind = Text(countDownBox, grid=[1,0], align="right", color="dark orange", bg="#0099ff", text="000000", size=40)
Text(countDownBox, grid=[1,1], text="", size=3)
countdown_real = Text(countDownBox, grid=[1,2], align="right", color="dark orange", bg="#0099ff", text="000000", size=40)


app.repeat(100, get_counter)




"""
# button_box and its elements
button_box = Box(app, grid=[0, 11])

connect_button = PushButton(button_box,
                            text="Connect",
                            command=connect,
                            padx=3,
                            pady=3)

disconnect_button = PushButton(button_box,
                               text="Disconnect",
                               command=disconnect,
                               padx=3,
                               pady=3)

# faces box and its elements

face_box = Box(app, grid=[0, 12])
"""
"""
faces_to_send_list = ButtonGroup(face_box, [
                ["Happy", "display.show(Image.HAPPY)"],
                ["Sad", "display.show(Image.SAD)"],
                ["Silly", "display.show(Image.SILLY)"],
                ["Yes", "display.show(Image.YES)"],
                ["No", "display.show(Image.NO)"],
                ["Pacman", "display.show(Image.PACMAN)"],
                ["Cow", "display.show(Image.COW)"]
                ],
                "display.show(Image.HAPPY)"
                )
                """
"""
send_button = PushButton(face_box,
                         text="Get",
                         command=get_data)

sim_button = PushButton(face_box,
                         text="Sim",
                         command=send_sim)

"""



# render app window
app.display()
