function [ind] = findIndices( ranges, dims )
% findIndices - Returns the linear indices corresponding to the elements in the given ranges of each dimension
%
% ranges = two-columns matrix of ranges: i-th row contains the ranges in the i-th dimension
% dims   = vector of the size of the array

dims = dims(:);
ndims = numel(dims);
nelem = diff(ranges')' + 1;
N = prod(nelem);
II = zeros(N,ndims);
II(:,1) = repmat( [ranges(1,1):ranges(1,2)]', prod(nelem(2:end)), 1 );
for k = 2:ndims-1
   Itemp = repmat( kron( [ranges(k,1):ranges(k,2)]', ones(prod(nelem(1:k-1)), 1) ), prod(nelem(k+1,end)), 1 );
   II(:,k) = Itemp(:);
end
Itemp = repmat( [ranges(ndims,1):ranges(ndims,2)], prod(nelem(1:end-1)), 1 );
II(:,ndims) = Itemp(:);
s = sprintf(',II(:,%d)',1:ndims);
ind = eval(['sub2ind(dims''',s,');']);
return



