function  TF = set_opt(psf, problem)
%
% MatLab function which sets the Fourier Transform of the PSF depending on
% the kind of problem (denoising or deblurring).
%
%% SYNOPSIS
% 
% TF = set_opt(psf, problem)
%
%% INPUT
%
% psf      = Point Spread Function image
% problem  = deblurring or denoising
%
%% OUTPUT
%
% TF           = fft of the psf
%

if strcmp(problem,'deblurring')
    TF  = fftn(fftshift(psf));
else % denoisign
    TF = ones(size(psf));
end

return

% =========================================================================
% End of set_opt.m file
% =========================================================================
