function [T] = shiftarray_3D_RT(arraySize)
% Forward translations along the columns (+Y, right-oriented)

% shiftarray_3D_RT - Right shifting operator for 3D periodic images
%   This function returns the rightward-shift operator for a 3D image assumed
%   to be vectorized and having periodic boundaries.
%
% SYNOPSIS
%   T = shiftarray_3D_RT(size)
%
% INPUT
%   arraySize (double array) - Size of the 3D image to be shifted, [num_x num_y num_z]
%
% OUTPUT
%   T    (sparse 0-1 array)  - Rightward-shifting operator. It is a very sparse
%                             square array sized (num_x*num_y*num_z) x
%                             (num_x*num_y*num_z)


num_x = arraySize(1);
num_y = arraySize(2);
num_z = arraySize(3);
N = prod(arraySize);

mn = num_x*num_y; mn1 = num_x*(num_y-1);
cols = [zeros(1,num_x), 1:N-num_x]';
ind = kron(mn*[0:num_z-1],ones(1,num_x))' + kron(ones(1,num_z),[1:num_x])';
cols(ind) = mn1 + ind;
T = sparse([1:N]',cols,ones(N,1),N,N);

return

% =========================================================================
% End of shiftarray_3D_RT.m file
% =========================================================================

