function [U_R, V_R] = grad_edgepreserving_2D()
% grad_edgepreserving - Compute the edge-pres. regularizer's splitted gradient
%   This function computes the two vectors U_R and V_R of the splitting of the
%   gradient for the edge-preserving regularization functional at the current
%   reconstruction x. The splitting is chosen as in [1].
%   All the needed operators must be already stored in the global structure
%   before calling this function.
%   WARNING: some columns of the operator array T in STATE_EDGEPRES_REG are
%   reused from previous calculation of regularizer value.
%
%   [1] M. Bertero, H. Lantieri, L. Zanni, "Iterative image reconstruction: 
%       a point of view", Proc. of 'Mathematical Methods in Biomedical Imaging
%       and Intensity-Modulated Radiation Therapy (IMRT)', 2007, 
%       Pubbl. Centro De Giorgi, Pisa, Italy.
%
% SYNOPSIS
%   [U_R, V_R] = grad_edgepreserving_2D()
%
% INPUT
%   none
%
% OUTPUT
%   U_R (double array) - positive part of the regularizer gradient split
%   V_R (double array) - negative part of the regularizer gradient split
%

global STATE_EDGEPRES_REG

%------------------------ grad TV value -----------------------------------
% WARNING: reusing T(:,1:4) and T(:,1:4) calculated in the previous TV value
% evaluation.

rad2 = sqrt(2);
N = numel(STATE_EDGEPRES_REG.x);

% . 4 .
% 3 x .
% . . .
% traslations for the gradient
STATE_EDGEPRES_REG.T(:,3) = STATE_EDGEPRES_REG.T_RT*STATE_EDGEPRES_REG.x;
STATE_EDGEPRES_REG.T(:,4) = STATE_EDGEPRES_REG.T_DW*STATE_EDGEPRES_REG.x;

U_R = zeros(N,1);
V_R = zeros(N,1);

temp = feval(STATE_EDGEPRES_REG.phi_prime,STATE_EDGEPRES_REG.norm_2g,STATE_EDGEPRES_REG.phi_par);

U_R = temp .* (STATE_EDGEPRES_REG.T(:,2) + STATE_EDGEPRES_REG.T(:,1));
V_R = 2*temp;

%temp = feval(STATE_EDGEPRES_REG.phi_prime,STATE_EDGEPRES_REG.T_RT*STATE_EDGEPRES_REG.norm_2g,STATE_EDGEPRES_REG.phi_par);
temp1 = STATE_EDGEPRES_REG.T_RT*temp;
U_R = U_R + temp1 .* STATE_EDGEPRES_REG.T(:,3);
V_R = V_R + temp1;

%temp = feval(STATE_EDGEPRES_REG.phi_prime,STATE_EDGEPRES_REG.T_DW*STATE_EDGEPRES_REG.norm_2g,STATE_EDGEPRES_REG.phi_par);
temp2 = STATE_EDGEPRES_REG.T_DW*temp;
U_R = U_R + temp2 .* STATE_EDGEPRES_REG.T(:,4);
V_R = (V_R + temp2) .* STATE_EDGEPRES_REG.x;

return

% =========================================================================
% End of grad_edgepreserving_2D.m file
% =========================================================================