%
% Matlab script designed to save data automatically. 
% It saves the whole workspace  in the 'Outputs directory'. If this 
% directory doesn't exists, this function creates it.
% If there exists a file with the same name chosen, the script put a suffix
% at the end of the file name. For example, if  the file 'results.mat'
% already exists, then automatically the script save the output in the file
% 'results01.mat'
%% SYNOPSIS
%
% datasave()
%   
%% INPUT
%
% name = name of the file to be saved; it is defined out of this script.
% 

if ~isdir('Outputs')
    mkdir('Outputs');
end
cd('Outputs');
filelist = dir('*.mat');

count = 0;
output = [nameobjs,'_ris.mat'];
for ll = 1 : length(filelist)
    if strcmp(filelist(ll).name,output)
        count = count+1;
        if count<10
            output = [nameobjs,'_ris0',num2str(count),'.mat'];
        else
            output = [nameobjs,'_ris',num2str(count),'.mat'];
        end
    end
end

save(output);
cd('..')

% ==============================================================================
% End of datasave.m file 
% ==============================================================================
