function div = fval_div_3D(Y)
% fval_div_3D - Compute the divergence at Y.
%
%   All the needed operators must be already stored in the global structure
%   STATE_EDGEPRES_REG before calling this function.
%
% SYNOPSIS
%   div = fval_div_3D(Y)
%
% INPUT
%   Y       (double array) - vectorized components of the gradient at x
%
% OUTPUT
%   div     (double array) - divergence value at x
%
% This software is developed within the research project
%
%        PRISMA - Optimization methods and software for inverse problems
%                           http://www.unife.it/prisma
%
% funded by the Italian Ministry for University and Research (MIUR), under
% the PRIN2008 initiative, grant n. 2008T5KA4L, 2010-2012. This software is
% part of the package "IRMA - Image Reconstruction in Microscopy and Astronomy"
% currently under development within the PRISMA project.
%
% Version: 1.0
% Date:    May 2012

% Authors: 
%   Alessandro Benfenati
%    Dept. of Mathematics, University of Ferrara, Italy
%    bnflsn@unife.it
%
% Software homepage: http://www.unife.it/prisma/software
%
% Copyright (C) 2012 by A. Benfenati
% ------------------------------------------------------------------------------
% COPYRIGHT NOTIFICATION
%
% Permission to copy and modify this software and its documentation for 
% internal research use is granted, provided that this notice is retained 
% thereon and on all copies or modifications. The authors and their
% respective Universities makes no representations as to the suitability 
% and operability of this software for any purpose. It is provided "as is"
% without express or implied warranty. Use of this software for commercial
% purposes is expressly prohibited without contacting the authors.
%
% This program is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation; either version 3 of the License, or (at your 
% option) any later version.
%
% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along 
% with this program; if not, either visit http://www.gnu.org/licenses/
% or write to
% Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
% =========================================================================

global STATE_EDGEPRES_REG

temp1 = STATE_EDGEPRES_REG.T_RT*Y(:,1);
temp2 = STATE_EDGEPRES_REG.T_DW*Y(:,2);
temp3 = STATE_EDGEPRES_REG.T_FR*Y(:,3);

div = -Y(:,1) + temp1 -Y(:,2) +temp2 - Y(:,3) +temp3;

return
% =========================================================================
% End of fval_div_3D.m file
% =========================================================================
