function edgepreserving_3D(obj_size, phi, phi_prime, phi_par)
% edgepreserving - Prepare an edge-preserving regularization algorithm
%   This function simply sets-up the contents of the global structure
%   STATE_EDGEPRES_REG that is used to apply an edge-preserving regularization
%   algorithm. The structure contains operator arrays as well as the reference
%   to the regularization functional and its discrete derivative.
%
% SYNOPSIS
%   edgepreserving_3D(obj_size, phi, phi_prime, phi_par)
%
% INPUT
%   obj_size   (integer array)   - the actual size of the unknown object
%   phi        (function handle) - func. handle of the regularization functional
%   phi_prime  (function handle) - func. handle of the first derivative of phi
%   phi_par    (double array)    - parameters needed by phi and phi_prime
%
% OUTPUT
%   none
%       parameters needed by phi and phi_prime
%
% This software is developed within the research project
%
%        PRISMA - Optimization methods and software for inverse problems
%                           http://www.unife.it/prisma
%
% funded by the Italian Ministry for University and Research (MIUR), under
% the PRIN2008 initiative, grant n. 2008T5KA4L, 2010-2012. This software is
% part of the package "IRMA - Image Reconstruction in Microscopy and Astronomy"
% currently under development within the PRISMA project.
%
% Version: 1.0
% Date:    July 2011

% Authors: 
%   Riccardo Zanella, Gaetano Zanghirati
%    Dept. of Mathematics, University of Ferrara, Italy
%    riccardo.zanella@unife.it, g.zanghirati@unife.it
%   Roberto Cavicchioli, Luca Zanni
%    Dept. of Pure Appl. Math., Univ. of Modena and Reggio Emilia, Italy
%    roberto.cavicchioli@unimore.it, luca.zanni@unimore.it
%
% Software homepage: http://www.unife.it/prisma/software
%
% Copyright (C) 2011 by R. Cavicchioli, R. Zanella, G. Zanghirati, L. Zanni.
% ------------------------------------------------------------------------------
% COPYRIGHT NOTIFICATION
%
% Permission to copy and modify this software and its documentation for 
% internal research use is granted, provided that this notice is retained 
% thereon and on all copies or modifications. The authors and their
% respective Universities makes no representations as to the suitability 
% and operability of this software for any purpose. It is provided "as is"
% without express or implied warranty. Use of this software for commercial
% purposes is expressly prohibited without contacting the authors.
%
% This program is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation; either version 3 of the License, or (at your 
% option) any later version.
%
% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along 
% with this program; if not, either visit http://www.gnu.org/licenses/
% or write to
% Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
% =========================================================================


% global structure
global STATE_EDGEPRES_REG

if prod(size(STATE_EDGEPRES_REG))
    warning('Global structure already in use: deleting the old one');
    clear global STATE_EDGEPRES_REG
    global STATE_EDGEPRES_REG
    STATE_EDGEPRES_REG.flag = true;
end

% STATE_EDGEPRES_REG.T_UP           operators
%                   .T_LT
%                   .T_BK
% STATE_EDGEPRES_REG.T_DW           operators
%                   .T_RT
%                   .T_FR
%                   .T              traslations
%                   .norm_2g
%                   .x              current point


%%%%%%%%%%%%%%%%%%%%%%
% traslation operators
%%%%%%%%%%%%%%%%%%%%%%
STATE_EDGEPRES_REG.T_DW = shiftarray_3D_DW(obj_size);
STATE_EDGEPRES_REG.T_UP = STATE_EDGEPRES_REG.T_DW';
STATE_EDGEPRES_REG.T_RT = shiftarray_3D_RT(obj_size);
STATE_EDGEPRES_REG.T_LT = STATE_EDGEPRES_REG.T_RT';
STATE_EDGEPRES_REG.T_FR = shiftarray_3D_FR(obj_size);
STATE_EDGEPRES_REG.T_BK = STATE_EDGEPRES_REG.T_FR';

N = prod(obj_size);

STATE_EDGEPRES_REG.T = zeros(N,6);          % traslations
STATE_EDGEPRES_REG.norm_2g = zeros(N,1);    % spatial gradient

STATE_EDGEPRES_REG.phi = phi;
STATE_EDGEPRES_REG.phi_prime = phi_prime;
STATE_EDGEPRES_REG.phi_par = phi_par;

return

% =========================================================================
% End of edgepreserving_3D.m file
% =========================================================================
