function [obj, gn, psf, bg, beta, varargout] = dataload(name)
%
% Matlab function to load data automatically. In case of unknown true
% object and unknow optimal beta, these 2 variables are set as void.
%
%% SYNOPSIS
%
% [obj, gn, psf, bg, beta, varargout] = dataload(name)
%   
% In the file [name].mat the data for the problem are stored; the structure
% of the file is the following: obj is the true object, gn is the detected
% image, psf is the Point Spread Function Image, bg  is the background
% term, beta is the regularization parameter. If the ground truth solution
% is known, it is stored in the x variable (in the file [name].mat).
% The mat file is stored in the 'Data' folder.
%
%% INPUT
%
% name = name of the file
%
%% OUTPUT 
% 
% obj          = true object
% gn           = noisy and blurred image
% psf          = point spread function
% bg           = background term
% beta         = reg. parameter
% varargout{1} = ground thruth 
%

cd('Data');
load(name);
cd('..');

if nargout>5
    varargout{1} = x;
end

return

% ==============================================================================
% End of dataload.m file 
% ==============================================================================

