function [T] = shiftarray_3D_FR(arraySize)
% Forward translations along the slices (+Z, front-oriented)
% shiftarray_3D_FR - Forward shifting operator for 3D periodic images
%   This function returns the forward-shift operator for a 3D image assumed
%   to be vectorized and having periodic boundaries.
%
% SYNOPSIS
%   T = shiftarray_3D_FR(size)
%
% INPUT
%   arraySize (double array) - Size of the 3D image to be shifted, [num_x num_y num_z]
%
% OUTPUT
%   T    (sparse 0-1 array)  - Forward-shifting operator. It is a very sparse
%                             square array sized (num_x*num_y*num_z) x
%                             (num_x*num_y*num_z)


num_x = arraySize(1);
num_y = arraySize(2);
num_z = arraySize(3);
N = prod(arraySize);

mnk1 = num_x*num_y*(num_z-1);
cols = [ [mnk1+1:N],[1:mnk1] ]';
T = sparse([1:N]',cols,ones(N,1),N,N);

return

% =========================================================================
% End of shiftarray_3D_FR.m file
% =========================================================================