function [T] = shiftarray_3D_DW(arraySize)
% Forward translations along the rows (+X, down-oriented)
% shiftarray_3D_DW - Down shifting operator for 3D periodic images
%   This function returns the downward-shift operator for a 3D image assumed
%   to be vectorized and having periodic boundaries.
%
% SYNOPSIS
%   T = shiftarray_3D_DW(size)
%
% INPUT
%   arraySize (double array) - Size of the 3D image to be shifted, [num_x num_y num_z]
%
% OUTPUT
%   T    (sparse 0-1 array)  - Downward-shifting operator. It is a very sparse
%                             square array sized (num_x*num_y*num_z) x
%                             (num_x*num_y*num_z)

num_x = arraySize(1);
num_y = arraySize(2);
num_z = arraySize(3);
N = prod(arraySize);

cols = [0, 1:N-1]';
cols(1:num_x:N-num_x+1) = [num_x:num_x:N]';
T = sparse([1:N]',cols,ones(N,1),N,N);

return

% =========================================================================
% End of shiftarray_3D_DW.m file
% =========================================================================