function f_prime = phi_prime_TV(t,delta);
% phi_prime_TV - Derivative of the phi function for TV functional
%   This function computes the first derivative of the function phi for the
%   Total Variation functional, at the current point.
%   In this case it is phi'(t) = 1/sqrt(t + delta^2).
%   If t is a vector, then the derivative is computed componentwise.
%
% SYNOPSIS
%   f_prime = phi_prime_TV(t, delta)
%
% INPUT
%   t        (sparse array) - discrete derivative operator
%   delta    (double)       - edge preserving parameter
%  
% OUTPUT
%   f_prime (double array) - phi'(t) for all t
%

f_prime = 1 ./ sqrt(t + delta*delta);

return
