function [J_R, D] = fval_edgepreserving_3D(x)
% SYNOPSIS
%   [J_R, D] = fval_edgepreserving(x)
%
% INPUT
%   x   (double array) - vectorized reconstruction
%
% OUTPUT
%   J_R (double)       - edge-preserving regularizer's value at x
%   D   (double array) - vector of gradient components
%
% This software is developed within the research project
%
%        PRISMA - Optimization methods and software for inverse problems
%                           http://www.unife.it/prisma
%
% funded by the Italian Ministry for University and Research (MIUR), under
% the PRIN2008 initiative, grant n. 2008T5KA4L, 2010-2012. This software is
% part of the package "IRMA - Image Reconstruction in Microscopy and Astronomy"
% currently under development within the PRISMA project.
%
% Version: 1.0
% Date:    July 2011

% Authors: 
%   Riccardo Zanella, Gaetano Zanghirati
%    Dept. of Mathematics, University of Ferrara, Italy
%    riccardo.zanella@unife.it, g.zanghirati@unife.it
%   Roberto Cavicchioli, Luca Zanni
%    Dept. of Pure Appl. Math., Univ. of Modena and Reggio Emilia, Italy
%    roberto.cavicchioli@unimore.it, luca.zanni@unimore.it
%
% Date:   May 2012
%  Modified by Alessandro Benfenati
%   Dept. of Mathematics, University of Ferrara, Italy
%   bnflsn@unife.it
%
% Software homepage: http://www.unife.it/prisma/software
%
% Copyright (C) 2011 by R. Cavicchioli, R. Zanella, G. Zanghirati, L. Zanni.
% ------------------------------------------------------------------------------
% COPYRIGHT NOTIFICATION
%
% Permission to copy and modify this software and its documentation for 
% internal research use is granted, provided that this notice is retained 
% thereon and on all copies or modifications. The authors and their
% respective Universities makes no representations as to the suitability 
% and operability of this software for any purpose. It is provided "as is"
% without express or implied warranty. Use of this software for commercial
% purposes is expressly prohibited without contacting the authors.
%
% This program is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation; either version 3 of the License, or (at your 
% option) any later version.
%
% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along 
% with this program; if not, either visit http://www.gnu.org/licenses/
% or write to
% Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
% =========================================================================

global STATE_EDGEPRES_REG

%------------------------ TV value ----------------------------------------
% calculate the value of the regularizer in x
% traslations for the objective function
% . . .
% . x 1
% . 2 .

% storing the point
STATE_EDGEPRES_REG.x = x;

STATE_EDGEPRES_REG.T(:,1) = STATE_EDGEPRES_REG.T_LT*x;
STATE_EDGEPRES_REG.T(:,2) = STATE_EDGEPRES_REG.T_UP*x;
STATE_EDGEPRES_REG.T(:,3) = STATE_EDGEPRES_REG.T_BK*x;

% differences
D = zeros(numel(x),3);
%
% Modified by Alessandro Benfenati
% 
D2 = zeros(numel(x),3);
for ii = [ 1 2 3 ],
    D(:,ii) = -x + STATE_EDGEPRES_REG.T(:,ii);
    D2(:,ii) = D(:,ii) .* D(:,ii);
end

STATE_EDGEPRES_REG.norm_2g = D2(:,1) + D2(:,2) + D2(:,3);

% Modified by Alessandro Benfenati: the original version was
%  J_R = 0.5*sum(feval(STATE_EDGEPRES_REG.phi,STATE_EDGEPRES_REG.norm_2g,STATE_EDGEPRES_REG.phi_par));
%
J_R = sum(feval(STATE_EDGEPRES_REG.phi,STATE_EDGEPRES_REG.norm_2g,STATE_EDGEPRES_REG.phi_par));

return
% =========================================================================
% End of fval_edgepreserving_3D.m file
% =========================================================================

