%       ImageErrorLoop.m

% Modify the section that loads the images at will.
% The images should be stored into double two-dimensional matrixes: I_true
% and I_filt

% The indexes for the images with name 'img', extension '.mat' and suffix from 
% ffile = 1 to lfile = 10 are computed with step step = 1.

% name = 'img_';
% ext = '.mat';
% ffile = 3;
% lfile = 6;
% step = 1;    

% figure_plot = true (visualizes the error indexes)
% image_plot = true (visualizes image difference)

% N returned by KLD_index is the number of pixels with non zero value
%

% ##################################################################

clear; format compact; format long;

name = 'img_';
ext = '.mat';
ffile = 3;
lfile = 6;
step = 1;    

figure_plot = true; 
image_plot = true;  

% ############ Load images
load 'LF_10000_gtrue_.mat';

I_true = double(gTrue);

k = 0;
for i=ffile:step:lfile
    k = k + 1;
    
    disp('  ');
    disp(['File Number ', num2str(i)]);
    
    % load file
    fullname= [name, num2str(i,'%d'),ext]
    load(fullname);
    I_filt = u;
    % ############ end loading images and assigning them to I_true and I_filt.

    [FSIM, SSIM, KLD, N, MAE, NMAE, PSNR, RMSE, SNR, L2RE] = ...
        ComputeInd(I_filt, I_true, 2)

    FSIMv(k) = FSIM;
    SSIMv(k) = SSIM;
    KLDv(k) = KLD;
    N_notZerov(k) = N;
    MAEv(k) = MAE;
    NMAEv(k) = NMAE;
    PSNRv(k) = PSNR;
    RMSEv(k) = RMSE;
    SNRv(k) = SNR;
    L2REv(k) = L2RE;
    
    if (image_plot)
        figure(10+k); clf; imagesc(u-I_true); colormap gray; colorbar; 
        title(['file number ',num2str(i)]);
    end;
end;

if (figure_plot)
    figure(1); clf; plot(ffile:step:lfile, FSIMv); hold on; title('FSIM');
    figure(2); clf; plot(ffile:step:lfile, SSIMv); hold on; title('SSIM');
    figure(3); clf; plot(ffile:step:lfile, KLDv); hold on; title('KLD');
    figure(4); clf; plot(ffile:step:lfile, MAEv); hold on; title('MAE');
    figure(5); clf; plot(ffile:step:lfile, NMAEv); hold on; title('NMAE');
    figure(6); clf; plot(ffile:step:lfile, PSNRv); hold on; title('PSNR');
    figure(7); clf; plot(ffile:step:lfile, RMSEv); hold on; title('RMSE');
    figure(8); clf; plot(ffile:step:lfile, SNRv); hold on; title('SNR');
    figure(9); clf; plot(ffile:step:lfile, L2REv); hold on; title('L2RE');
end;
