%       ImageError.m
%
% [FSIM, SSIM, KLD, N, MAE, NMAE, PSNR, RMSE, SNR, L2RE] = ...
% ComputeInd(I_filt, I_true, N_Border); 
% N_border is the number of pixels that constitute the border of the image
% that should not be considered

% Modify the section that loads the images at will.
% The images should be stored into double two-dimensional matrixes: I_true
% and I_filt

% N returned by KLD_index is the number of pixels with non zero value
%

clear; format compact; format long;

% ############ Load images
load 'LF_10000_gtrue_.mat';
load 'img_3.mat';

I_true = double(gTrue);
I_filt = u;

% ############ end loading images and assigning them to I_true and I_filt.

[FSIM, SSIM, KLD, N, MAE, NMAE, PSNR, RMSE, SNR, L2RE] = ...
    ComputeInd(I_filt, I_true, 2); 
    
FSIM = FSIM
SSIM = SSIM
KLD = KLD
N_notZero = N
MAE = MAE
NMAE = NMAE
PSNR = PSNR
RMSE = RMSE
SNR = SNR
L2RE = L2RE


