function [KL,N] = KLD_index(data_true, data_filtered, varargin)
% Code from R. Zanella, 

% data_true are the filtered data that have to be evaluated
% data_filtered are the reference data.
% THIS MAY CREATE SOME CONFUSION
% Kullback-Leibler divergence of data_filtered from data_true
% KL = KLD_index(data_true, data_filtered)
% KL = sum_i [ data_true_i * ln (data_true_i / data_filtered_i) + data_filtered_i - data_true_i ]
% where:
%	data_true * log data_true = 0	if data_true > tolpos
%	data_filtered_i != 0 for any i
%
%
% optional parameters:
% tolpos	DEFAULT = 1e-5
% KL = KLD_index(data_true, data_filtered, tolpos)


% set defaults for optional parameters
tolpos = 1e-5;

% test for number of required params
if(nargin - length(varargin)) ~= 2
	error('Wrong number of required parameters');
end

if (length(varargin) == 1)
	tolpos = varargin{1};
end

data_filtered = data_filtered(:);
data_true = data_true(:);

N = numel(data_true);
zeroindex = find(data_true <= tolpos );        	% positions of the zero values in data_true
nonzeroindex = setdiff([1:N],zeroindex);	% positions of the non zero values in gn

rapp = data_true ./ data_filtered ;
KL = sum( data_true(nonzeroindex) .* log(rapp(nonzeroindex)) + data_filtered(nonzeroindex) - data_true(nonzeroindex) );
N = numel(nonzeroindex);
