%       ComputeInd.m

% Compute similarity indexes

% FSIM has been modified to accept gray level images with an arbitrary
% number of gray levels.
% SSIM has been implemented using a Gaussian window of 11 pixels with sigma
% = 1.5

% N returned by KLD_index is the number of pixels with non zero value
%

% ############ end loading images and assigning them to I_true and I_filt.
% I_filt --> I1
% I_true --> I2

function [FSIM, SSIM, KLD, N, MAE, NMAE, PSNR, RMSE, SNR, L2RE] = ...
    ComputeInd(I1, I2, N_border)

dim = size(I2)
n_pixels = dim(1)*dim(2)
disp(' ');

I1 = I1(N_border+1:end-N_border, N_border+1:end-N_border);
I2 = I2(N_border+1:end-N_border, N_border+1:end-N_border);

FSIM = FSIM_index(I1, I2, 'scharr')

[mssim, ssim_map] = SSIM_index(I1, I2);
SSIM = mssim;

% KLD = sum_i [ I1_i * ln (I1_i / I2_i) + I2_i - I1_i ];
[KLD,N] = KLD_index(I1, I2);

% Mean absolute error
% MAE =  1/N * sum_i [ | data_filtered_i - data_true_i | ]
MAE = MAE_index(I1, I2);

% Normalized mean absolute error
% NMAE = sum(abs(I_filt(:)- I_true(:)))/(sum(I_true(:)));
NMAE = NMAE_index(I1, I2);

% Peak Signal to Noise Ratio
% PSNR = 10*log10((max(I_true(:))^2) * N / sum((I_true(:)-I_filt(:)).^2));
PSNR = PSNR_index(I1, I2);

% Root Mean Squared Error
% R = sqrt[ 1/N * sum_i [ (data_filtered_i - data_true_i)^2] ]
RMSE = RMSE_index(I1, I2);

% Signal to Noise Ratio
% snr = 10*log10(sum(I_true(:).^2)/sum((I_true(:)-I_filt(:)).^2));
SNR = SNR_index(I1, I2)

% Relative error in l2.
L2RE = L2RE_index(I1, I2)



