%% Demo script to test the SGP method on deblurring problems
%% Data from .mat files
% This software is part of the package 
%
%             IRMA - Image Reconstruction in Microscopy and Astronomy
%                            http://www.unife.it/irma
%
% developed within the research project
%
%        PRISMA - Optimization methods and software for inverse problems
%                           http://www.unife.it/prisma
%
% funded by the Italian Ministry for University and Research (MIUR), under the
% PRIN2008 initiative, grant n. 2008T5KA4L, 2010-2012.
%
% Version: 1.0
% Date:    July 2011
%
% ------------------------------------------------------------------------------
% Authors: 
%   Riccardo Zanella, Gaetano Zanghirati
%    Dept. of Mathematics, University of Ferrara, Italy
%    riccardo.zanella@unife.it, g.zanghirati@unife.it
%   Roberto Cavicchioli, Luca Zanni
%    Dept. of Pure Appl. Math., Univ. of Modena and Reggio Emilia, Italy
%    roberto.cavicchioli@unimore.it, luca.zanni@unimore.it
%
% Software homepage: http://www.unife.it/irma
%                    http://www.unife.it/prisma/software
%
% Copyright (C) 2011 by R. Cavicchioli, R. Zanella, G. Zanghirati, L. Zanni.
% ------------------------------------------------------------------------------
% COPYRIGHT NOTIFICATION
%
% Permission to copy and modify this software and its documentation for 
% internal research use is granted, provided that this notice is retained 
% thereon and on all copies or modifications. The authors and their
% respective Universities makes no representations as to the suitability 
% and operability of this software for any purpose. It is provided "as is"
% without express or implied warranty. Use of this software for commercial
% purposes is expressly prohibited without contacting the authors.
%
% This program is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version.
%
% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along 
% with this program; if not, either visite http://www.gnu.org/licenses/
% or write to
% Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
% ==============================================================================

%% INPUT
dir_input = '../input';
%problem = 'satellite_25500'; 
problem = 'NGC7027_255';
%% ATTENTION
% remember to set a stopping rule suited for the given test set;
% see below (lines 90 - 108). 

%% OUTPUT
dir_output = '../output';

if isempty(dir_input)
    dir_input = pwd;
end
if isempty(dir_output)
    dir_output = pwd;
end

fprintf('Input data: %s\n',dir_input);
fprintf('Saving in:  %s\n',dir_output);

%% Load the data
load(sprintf('%s%s%s',dir_input,filesep,sprintf('%s.mat',problem)));

% deblurring
dimensions = size(psf);
% Check normalization of the blurring operator A (PSF)
sumPSF = sum(psf(:)); 
checkPSF = abs(sumPSF-1); tolCheckPSF = 1.0e4*eps;
if (checkPSF > tolCheckPSF)
    errmsg = sprintf('\n\t|sum(psf(:)) - 1| = %e,  tolerance = %e\n',checkPSF,tolCheckPSF);
    error('Not-normalized PSF: provide a normalized PSF (see documentation).%s',errmsg);
end
TF = fftn(fftshift(psf));
CTF = conj(TF);
A  = @(x) Afunction(x,TF,dimensions);
AT  = @(x) Afunction(x,CTF,dimensions);

%% ATTENTION
% A criterion for managing the early stopping of SGP must be fixed:
% if STOPCRITERION = 1, then SGP stops after maxit iterations 
% (default value: maxit=1000); by setting STOPCRITERION = 2,3,4, other 
% criteria can be exploited jointly with the previous one
% (see the documentation about the "STOPCRITERION" input argument).

maxit = 27; % suited for "NGC7027_255" test set and STOPCRITERION = 1
% maxit = 332; % suited for "satellite_25500" test set and STOPCRITERION = 1
% maxit = ... % to be fixed for your test set and your stopping criterion

[ x, iter_tmp, err_tmp, discr_tmp, times_tmp ] = sgp_deblurring(A, gn,...
    'AT', AT, ...
    'MAXIT', maxit, ...
    'BG', bg, ...
    'VERBOSE', 2, ...
    'STOPCRITERION', 1, ...
    'INITIALIZATION', 3, ...
    'OBJ', obj);

fprintf(' SGP: iter. = %d, L2 rec. err. = %e\n', iter_tmp, err_tmp(end));

save(sprintf('%s%s%s_DEBLURR.mat',dir_output,filesep,problem), ...
                          'x', 'iter_tmp', 'err_tmp', 'discr_tmp', 'times_tmp');
% ==============================================================================
% End of test_deblurring.m file - IRMA package
% ==============================================================================

