PRO test_deblurring_single, A, gn, x, iter, err, discr, times, obj = obj, bg = bg, $
                            maxit = maxit, bound = bound, algo = algo, verb = verb, GPU = GPU, $
                            tol = tol, stopcrit = stopcrit, init_case = init_case

; test_deblurring_single - script to run various algorithms
;   This program set and launches various algorithms to solve
;   a single image deblurring problem
;
; SYNOPSIS
;    test_deblurring_single, A, gn, x, iter, err, discr, times [, opts]
;
; MANDATORY INPUT
;   A   (double array) - measuring matrix used to apply the blurring
;                        operator, that is to compute A*x
;   gn  (double array) - measured image
;
; OPTIONAL INPUT
;   The following options must be provided as keyword/value pairs.
;   'OBJ'              - Exact solution, for error calculation (double array)
;   'BG'               - Background value (double)
;                        DEFAULT = 0
;   'MAXIT'            - Maximum number of iterations (integer)
;                        DEFAULT = 1000
;   'VERB'             - Verbosity level (integer)
;                        0 - silent
;                        1 - print configuration parameters at startup
;                        DEFAULT = 0
;   'ALGO'             - Algorithm to be used (char)
;                        'S' SGP
;                        'R' RL
;                        'O' OSEM
;                        DEFAULT = 'S'
;   'STOPCRIT'         - Choice for stopping rule (integer)
;                        1 -> iter > MAXIT
;                        2 -> ||x_k - x_(k-1)|| <= tol*||x_k|| OR iter > MAXIT
;                        3 -> |KL_k - KL_(k-1)| <= tol*|KL_k| OR iter > MAXIT
;                        4 -> (2/N)*KL_k <= tol OR iter > MAXIT
;                        DEFAULT = 1
;   'INIT_CASE'        - Choice for starting point:
;                        0  - all zero starting point
;                        1  - initialization with gn
;                        2  - initialization with
;                               ones(size(gn))*sum(gn(:) - bg) / numel(gn)
;                        x0 - user-provided starting point (double array)
;                        DEFAULT = 2
;   'BOUND'            - Flag to enable bound effect reduction
;   'TOL'              - Tolerance used in the stopping criterion
;                        DEFAULT = 1e-4 if STOPCRITERION = 2 or 3
;                        DEFAULT = 1+1/mean(gn) if STOPCRITERION = 4
;   'GPU'              - Flag to enable GPU acceleration
;                        DEFAULT = 0
;
; OUTPUT
;   x                  - Reconstructed data
;   iter               - Number of iterations
;   err                - Error value at each iteration. If OBJ was not given,
;                        then err is the empty matrix.
;   discr              - Discrepancy value after each iteration:
;                            D = 2/numel(x_k) * KL( Ax_k + bg, gn)
;   times              - Time elapsed after each iteration
;
; ------------------------------------------------------------------------------
;
; This software is developed within the research project
;
;        PRISMA - Optimization methods and software for inverse problems
;                           http://www.unife.it/prisma
;
; funded by the Italian Ministry for University and Research (MIUR), under
; the PRIN2008 initiative, grant n. 2008T5KA4L, 2010-2012. This software is
; part of the package "IRMA - Image Reconstruction in Microscopy and Astronomy"
; currently under development within the PRISMA project.
;
; Version: 1.0
; Date:    July 2011

; Authors:
;   Roberto Cavicchioli, Marco Prato, Luca Zanni
;    Dept. of Pure Appl. Math., Univ. of Modena and Reggio Emilia, Italy
;    roberto.cavicchioli@unimore.it, marco.prato@unimore.it, luca.zanni@unimore.it
;   Mario Bertero, Patrizia Boccacci
;    DISI (Dipartimento di Informatica e Scienze dell'Informazione), University of Genova, Italy
;    bertero@disi.unige.it, boccacci@disi.unige.it
;
; Software homepage: http://www.unife.it/prisma/software
;
; Copyright (C) 2011 by M. Bertero, P. Boccacci, R. Cavicchioli, M. Prato, L. Zanni.
; ------------------------------------------------------------------------------
; COPYRIGHT NOTIFICATION
;
; Permission to copy and modify this software and its documentation for
; internal research use is granted, provided that this notice is retained
; thereon and on all copies or modifications. The authors and their
; respective Universities makes no representations as to the suitability
; and operability of this software for any purpose. It is provided "as is"
; without express or implied warranty. Use of this software for commercial
; purposes is expressly prohibited without contacting the authors.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3 of the License, or (at your
; option) any later version.
;
; This program is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; See the GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License along
; with this program; if not, either visite http://www.gnu.org/licenses/
; or write to
; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
; ==============================================================================

err_calc = 1B

; Default parameters
if (keyword_set(obj) - 1)         then err_calc = 0B    ; Error calculation (0B, 1B)
if (keyword_set(bg) - 1)          then bg = 0           ; background value
if (keyword_set(maxit) - 1)       then maxit = 50       ; maximum number of iterations
if (keyword_set(bound) - 1)       then bound = 0B       ; bound effects (0B, 1B)
if (keyword_set(algo) - 1)        then algo = 'S'       ; reconstruction algorithm ('R','S')
if (keyword_set(verb) - 1)        then verb = 0         ; 0 -> silent
if (keyword_set(stopcrit) - 1)    then stopcrit = 1     ; 1 -> number of iterations
if (keyword_set(init_case) - 1)   then init_case = 2    ; 2 -> constant image
if (keyword_set(GPU) - 1)         then begin            ; GPU usage (0B, 1B)
                                       GPU_flag = 0B
                                  endif else begin
                                       GPU_flag = GPU
                                  endelse

dims = n_elements(size(gn,/dimensions))

if err_calc then begin
   if (algo eq 'R') then begin
      if GPU_flag then begin
         if bound then begin
            rl_deblurring_single_bound_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                            bg = bg, obj = obj, verb = verb, tol = tol, stopcrit = stopcrit
         endif else begin
            rl_deblurring_single_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                      bg = bg, obj = obj, verb = verb, tol = tol, stopcrit = stopcrit
         endelse
      endif else begin
         rl_deblurring, A, gn, x, iter, err, discr, times, maxit = maxit, $
                        bg = bg, bound = bound, obj = obj, verb = verb, tol = tol, stopcrit = stopcrit
      endelse
   endif else begin
      if (algo eq 'S') then begin
         if GPU_flag then begin
            if bound then begin
               sgp_deblurring_single_bound_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                                bg = bg, obj = obj, verb = verb, tol = tol, $
                                                stopcrit = stopcrit
            endif else begin
               sgp_deblurring_single_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                          bg = bg, initialization = init_case, obj = obj, $
                                          verb = verb, tol = tol, stopcrit = stopcrit
            endelse
         endif else begin
            sgp_deblurring, A, gn, x, iter, err, discr, times, maxit = maxit, $
                            bg = bg, bound = bound, initialization = init_case, obj = obj, $
                            verb = verb, tol = tol, stopcrit = stopcrit
         endelse
      endif else begin
         print, 'Algorithm specified not existing'
         return
      endelse
   endelse
endif else begin
   if (algo eq 'R') then begin
      if GPU_flag then begin
         if bound then begin
            rl_deblurring_single_bound_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                            bg = bg, verb = verb, tol = tol, stopcrit = stopcrit
         endif else begin
            rl_deblurring_single_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                      bg = bg, verb = verb, tol = tol, stopcrit = stopcrit
         endelse
      endif else begin
         rl_deblurring, A, gn, x, iter, err, discr, times, maxit = maxit, $
                        bg = bg, bound = bound, verb = verb, tol = tol, stopcrit = stopcrit
      endelse
   endif else begin
      if (algo eq 'S') then begin
         if GPU_flag then begin
            if bound then begin
               sgp_deblurring_single_bound_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                                bg = bg, verb = verb, tol = tol, stopcrit = stopcrit
            endif else begin
               sgp_deblurring_single_gpu, A, gn, x, iter, err, discr, times, maxit = maxit, $
                                          bg = bg, initialization = init_case, $
                                          verb = verb, tol = tol, stopcrit = stopcrit
            endelse
         endif else begin
            sgp_deblurring, A, gn, x, iter, err, discr, times, maxit = maxit, $
                            bg = bg, bound = bound, initialization = init_case, $
                            verb = verb, tol = tol, stopcrit = stopcrit
         endelse
      endif else begin
         print, 'Algorithm specified not existing'
         return
      endelse
   endelse
endelse

END

; ==============================================================================
; End of test_deblurring_single.pro file - IRMA package
; ==============================================================================