% 
%  Matlab code for article:  An Iterative algorithm for large size
%  Least-Squares constrained regularization problems, by E. Loli Piccolomini
%  and F. Zama, Applied Mathematics and Computations,vol. 217,
%  pp.10343-10354, 2011.
%
clear all
close all
%
% Requires Hansen's Regtool
%
J=123456;randn('seed',J);

n=512; % Problem size
MaxIter=n;
k_s=3; % Secant iterations
%
verb=-1;% Set 1 for iterations   plots
zeta_noise=0.1; % tol = zetanoise * rho see (28) article 

[A,b,x_true] = shaw(n);   Prob='Shaw';TOL=-1;
nL=1;
[L,W] = get_l(n,nL);   
fprintf(' Prob= %s  n=%d L=%d k_s = %d \n',Prob, n, nL, k_s)
fprintf(' noiselev , iter(it_int),   lambda,   Erel,    gamma,    noise est  \n ')    
Lx_true=L*x_true;gamma_true=dot(Lx_true,Lx_true);NST=norm(x_true);
noiselev=1.e-4;
v=randn(size(b));v=v/norm(v);
bn=b+noiselev*v*norm(b);
%     
        params=[k_s,gamma_true,-1,MaxIter,verb,zeta_noise];
        [x,lambda,it_int,gamma,noise_val,iter]=CLSRit(A,L,bn,params,x_true);
 %       
        e_x1=norm(x-x_true)/NST; Enoise=abs(noiselev-noise_val)/noise_val;  
     fprintf(' %10.3e & %d (%d) & %10.3e & %10.3e & %10.3e & %10.3e \n',noiselev,iter,it_int,lambda,e_x1,gamma,noise_val)
     
 figure;plot(1:length(x),x,'-b',1:length(x),x_true,'-r') ; axis tight;
 title(['Test:', Prob, '   Solution Plot. Iteration =', num2str(iter)]);
 legend('Computed Sol.', 'True Sol.')
 