function [x,lambda,it_int,gamma,noise,it]=CLSRit(A,L,bn,params,x_true)
%CLSRit method for the solution of the linear least-squares problem:
%                  Ax=b
% with Tikhonov regularization method. The regularization parameter is
% automatically computed by the algorithm.
%
%  Matlab code for the paper:  An Iterative algorithm for large size
%  Least-Squares constrained regularization problems, by E. Loli Piccolomini
%  and F. Zama, Applied Mathematics and Computations,vol. 217,
%  pp.10343-10354, 2011.
%
% input parameters:
%
%A: coefficient matrix of size mXn, m>n
%L Tikhonov regularization matrix
% bn: data with noise
% params: vector of parameters with the following components:
%        (1): number of bisection iterations to be performed
%        (2): value of \|Lx\|^2,where x is the exact solution
%        (3): value of the gamma parameter (see paper)
%        (4): maximum number of CLSRit iterations allowed
%        (5): if =0, verbose is off, if =1 verbose is on
%        (6): value of the parameter zeta_noise (see paper, formula (28))
%
% output parameters
%
% x: computed solution
% lambda: computed regularization parameter
% it_int: total number of internal (Conjugate Gradient) iterations performed
% gamma: computed value of the parameter gamma (step 1 of the algorithm,
% on pages 10346-10347)
% noise: computed noise estimation
% it: number of CLSRit iterations performed

[m,n]=size(A);

k_s=params(1);
gamma=params(2);
if k_s == -1, k_s = n; end % Bisection Default
Tol_cg=params(3);
maxiter=params(4);
if maxiter == -1, maxiter=n; end
verbose=params(5);
if verbose==-1, verbose=0;end
zeta_noise=params(6);
if zeta_noise==-1, zeta_noise=0.1; end

M1=A'*A;M2=L'*L;Hb=A'*bn; it=0;

noise=-1;
if Tol_cg==-1
     [x_ini,noise]=my_cgls_noise(A,bn);  
     Tol_cg=noise*zeta_noise;
     if noise > 5.e-3,
         Tol_cg=Tol_cg/3; % High noise (per non uscire troppo presto) xPhillips
    end
else
    x_ini=my_cgls(A,bn);
end
Li=L*x_ini;res=bn-A*x_ini;

if gamma == -1,
     gamma=dot(Li,Li);
     gamma=gamma*sqrt(norm(L,'inf')); % correzione 
end
lambda=dot(res,res);
[x,FLAG,RELRES,it_cg]= pcg(@(x)afun(x,M1,lambda,M2),Hb,Tol_cg,maxiter);

	if FLAG == 1, 
		fprintf('Max pcg iterations (%d) reached in it_cg=%d itertions \n',maxiter,it_cg);
     end

res=bn-A*x;
%
Lx=L*x;g1=dot(Lx,Lx);
Dg=(g1-gamma);
it_Dg=0;iter=0;
lambda_p=lambda;g1_p=g1;

while Dg >0
    it_Dg=it_Dg+1;
    if it_Dg >1
         delta=abs((lambda- lambda_p)/(g1 - g1_p));
         lambda_p=lambda;g1_p=g1;
         lambda=lambda+delta;
    else
       lambda=1.1*lambda;
    end
    [x,FLAG,RELRES,it_cg]= pcg(@(x)afun(x,M1,lambda,M2),Hb,Tol_cg,maxiter);
    	if FLAG == 1, 
        end
        
    Lx=L*x; g1=dot(Lx,Lx); Dg=(g1-gamma);
    iter=iter+it_cg;
end
continua=1;
it_int=0;

continua=1;it=1;
Lambda(it)=lambda; mu=lambda;
[x,FLAG,RELRES,it_cg]= pcg(@(x)afun(x,M1,lambda,M2),Hb,Tol_cg,maxiter);it_int=it_int+it_cg;
	if FLAG == 1, 
		fprintf('Max pcg iterations (%d) reached in it_cg=%d itertions \n',maxiter,it_cg);
    end

Lx=L*x;g1=dot(Lx,Lx);
r(it)=norm(bn-A*x);
if nargin == 5, ERR(it)=norm(x-x_true)/norm(x_true);end
x_prec=x;
    r1=bn-A*x;
    PHI(it)=dot(r1,r1)+lambda*(g1-gamma);
G0=abs(g1-gamma);
GG(it)=g1-gamma;tau_r=Tol_cg;tau_a=Tol_cg;
c_g1=1;
if lambda > noise,
while continua
    it=it+1;
    [x,FLAG,RELRES,it_cg]= pcg(@(x)afun(x,M1,lambda,M2),Hb,Tol_cg,maxiter);
	if FLAG == 1, 
		fprintf('Max pcg iterations (%d) reached in it_cg=%d itertions \n',maxiter,it_cg);
    end

    it_int=it_int+it_cg;
    r(it)=norm(bn-A*x);
    Lx=L*x;g1=dot(Lx,Lx);
    if nargin ==5, ERR(it)=norm(x-x_true)/norm(x_true);end
    r1=bn-A*x;
    PHI(it)=dot(r1,r1)+lambda*(g1-gamma);

    if it > k_s,
        
     if abs(g1-g1p)> 1.e-8,
        lambda=lambda-((g1-gamma)/(g1-g1p))*(lambda-Lambda(it-2));
     else
        c_g1=0;
     end

    else
        mu=min(lambda/2,mu/2);
        segno=sign(g1-gamma);
        lambda=lambda+segno*mu;
    end
    
    GG(it)=g1-gamma;
    cG=abs(GG(it)) > tau_r*G0+ tau_a;
    cG1 = sign(GG(it)) < 0;
    c_it = it < maxiter;
    ctol=  abs(lambda - Lambda(it-1)) > Tol_cg ;
   
    continua = cG1 & cG & ctol & c_it & c_g1;
    g1p=g1;    x_prec=x;     Lambda(it)=lambda;
end

end

if lambda <0,
    lambda=abs(lambda);
    [x,FLAG,RELRES,it_cg]= pcg(@(x)afun(x,M1,lambda,M2),Hb,Tol_cg,maxiter);
    	if FLAG == 1, 
		fprintf('Max pcg iterations (%d) reached in it_cg=%d itertions \n',maxiter,it_cg);
     end

    if nargin ==5, ERR(it)=norm(x-x_true)/norm(x_true);end
end

if verbose,
    figure;plot(1:length(GG),GG,'.-',1:length(GG),ones(size(GG))*(tau_r*G0+ tau_a),'-r');legend('G(\lambda)- \gamma','\gamma');xlabel('k');
    figure;plot(1:length(Lambda),Lambda,'.-');title('\lambda');xlabel('k')
    
    if nargin == 5, 
        figure;plot(1:length(ERR),ERR,'.-');title('Relative Error');xlabel('k')
        figure;plot(1:length(x),x,'-b',1:length(x),x_true,'-r') ;title(['Solution Plot. Iteration =',num2str(it)]);legend('Computed Sol.', 'True Sol.')
    
    end
end
%--------------------------------------------------------------------------
%
function [x] = my_cgls(A,b)
%
% CGLS for initial iteration
%
[m,n] = size(A); 
% Prepare for CG iteration.
x = zeros(n,1);
d = A'*b; r = b;
normr2 = dot(d,d);
% Iterate.
continua=1;j=0;
while continua
    j=j+1;
% Update x and r vectors.
  Ad = A*d; alpha = normr2/dot(Ad,Ad);
  xp=x;
  x  = x + alpha*d;
  r  = r - alpha*Ad;
  s  = A'*r;
  % Update d vector.
  normr2_new = dot(s,s);
  beta = normr2_new/normr2;
  normr2 = normr2_new;
  d = s + beta*d;
  rho(j) = norm(r); 
  continua=j < 500;
  if j > 1,
      ratio=rho(j)/rho(j-1); 
      continua =ratio < 0.9;
  end
end
x=xp;
%-------------------------------------------------------------------------
function [x_ini,eta] = my_cgls_noise(A,b)
%
% CGLS with noise estimation
%
[m,n] = size(A); 
% Prepare for CG iteration.
x = zeros(n,1);
d = A'*b; r = b;
normr2 = d'*d;
% Iterate.
continua=1;j=0;first=1;
while continua
    j=j+1;
% Update x and r vectors.
  Ad = A*d; alpha = normr2/(Ad'*Ad);
  xp=x;
  x  = x + alpha*d;
  r  = r - alpha*Ad;
  s  = A'*r;
  % Update d vector.
  normr2_new = s'*s;
  beta = normr2_new/normr2;
  normr2 = normr2_new;
  d = s + beta*d;
  rho(j) = norm(r);
  continua = j < 500;
  if j > 1 
      ratio = rho(j) / rho(j-1);
      if first,
         if ratio >= 0.9 
             first =0;
             x_ini=xp; it_ini=j;
         end
      else
          continua = j < 2*it_ini;
      end
  end
end
 y=A*x_ini;
z=y-b;
eta=norm(z)/norm(b);
y2=A*x;
z=y2-b;
eta2=norm(z)/norm(b);
p=round(log10(eta2/eta));
eta=eta*10^p;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [x,FLAG,RELRES, iter] = pcg(fun, b,tol, maxit)
FLAG=0;
x = zeros(size(b));
r = b; nb = norm(b);
num = r'*r; p = r;
err = sqrt(num);  iter = 0;
continua=1;
while continua
    iter = iter + 1;
    v = feval(fun,p); 
    den = dot(p,v); alfa = num/den;
    den = num;
    x = x + alfa*p; r = r - alfa*v;
    num = dot(r,r); err1 = sqrt(num);
    beta = num/den; 
    p = r + beta * p; 
     RELRES=err1;
    continua = (err1 > tol * nb & iter < maxit);
     err=err1;
     
end
if iter >= maxit, FLAG=1; end