/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.utils;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.Printer;
import javafx.print.PrinterAttributes;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.transform.Scale;
import javafx.stage.Window;

public class Utils {
    private Alert alert;
    public static ResourceBundle resourceBundle = ResourceBundle.getBundle("bundles.strings", new Locale("it", "IT"));
    private final ObjectProperty<Window> windowOwner = new SimpleObjectProperty();

    public Window getWindowOwner() {
        return (Window)this.windowOwner.get();
    }

    public void setWindowOwner(Window value) {
        this.windowOwner.set((Object)value);
    }

    public ObjectProperty<Window> windowOwnerProperty() {
        return this.windowOwner;
    }

    public static String getTimestamp() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy_HH_mm_ss");
        return sdf.format(date);
    }

    public static EventHandler<ActionEvent> openFileWithDefaultOSProgram(File file) {
        return event -> {
            if (Desktop.isDesktopSupported()) {
                new Thread(() -> {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                Utils.printlnError("Desktop not supported");
            }
        };
    }

    public static void printNode(Node node) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        boolean success;
        Printer printer = Printer.getDefaultPrinter();
        PageLayout pageLayout = printer.createPageLayout(Paper.A4, PageOrientation.LANDSCAPE, Printer.MarginType.DEFAULT);
        PrinterAttributes attr = printer.getPrinterAttributes();
        PrinterJob job = PrinterJob.createPrinterJob();
        double scaleX = pageLayout.getPrintableWidth() / node.getBoundsInParent().getWidth() + 0.15;
        double scaleY = pageLayout.getPrintableHeight() / node.getBoundsInParent().getHeight() + 0.15;
        Scale scale = new Scale(scaleX, scaleY);
        node.getTransforms().add((Object)scale);
        if (job != null && job.showPrintDialog(node.getScene().getWindow()) && (success = job.printPage(pageLayout, node))) {
            job.endJob();
        }
        node.getTransforms().remove((Object)scale);
    }

    public static String loadTextFiles(String fileName) throws IOException {
        String lines = "";
        try {
            lines = Files.lines(new File(fileName).toPath()).collect(Collectors.joining("\n"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return lines;
    }

    public static String listToString(List<String> list) {
        String result = "";
        for (String string : list) {
            result = result + string + "\n";
        }
        return result;
    }

    public static String loadTextFiles(BufferedReader bufferedReader) {
        String lines = "";
        try {
            while (bufferedReader.ready()) {
                lines = lines + bufferedReader.readLine() + "\n";
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return lines;
    }

    public CustomResults RequestYesNoCancelMsg(String Header, String Message2) {
        CustomResults result = CustomResults.CANCEL;
        try {
            this.alert = new Alert(Alert.AlertType.NONE);
            this.alert.setHeaderText(Header);
            this.alert.getDialogPane().setContent((Node)new Label(Message2));
            String sYes = resourceBundle.getString("rs_YES");
            String sNo = resourceBundle.getString("rs_NO");
            String sCancel = resourceBundle.getString("rs_Cancel");
            ButtonType buttonTypeYES = new ButtonType(sYes, ButtonBar.ButtonData.YES);
            ButtonType buttonTypeNO = new ButtonType(sNo, ButtonBar.ButtonData.NO);
            ButtonType buttonTypeCANCEL = new ButtonType(sCancel, ButtonBar.ButtonData.CANCEL_CLOSE);
            this.alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeYES, buttonTypeNO, buttonTypeCANCEL});
            Optional alresult = this.alert.showAndWait();
            result = alresult.get() == buttonTypeYES ? CustomResults.YES : (alresult.get() == buttonTypeNO ? CustomResults.NO : CustomResults.CANCEL);
        }
        catch (Exception e) {
            Utils.printlnError(String.format("[%s]: %s", Thread.currentThread().getStackTrace()[1].getMethodName(), e.getMessage()));
        }
        return result;
    }

    public void InfoMsg(Alert.AlertType AlType, String Header, String Message2) {
        this.alert = new Alert(Alert.AlertType.NONE);
        this.alert.setHeaderText(Header);
        this.alert.getDialogPane().setContent((Node)new Label(Message2));
        String sOk = resourceBundle.getString("rs_Ok");
        ButtonType buttonTypeOK = new ButtonType(sOk, ButtonBar.ButtonData.OTHER);
        this.alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOK});
        Button okButton = (Button)this.alert.getDialogPane().lookupButton(buttonTypeOK);
        okButton.setDefaultButton(true);
        this.alert.showAndWait();
    }

    public static String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public static Color darkerColor(Color color, double factor) {
        double r = color.getRed() * factor;
        double g = color.getGreen() * factor;
        double b = color.getBlue() * factor;
        Color newColor = Color.color((double)r, (double)g, (double)b);
        return newColor;
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public static void print(String string) {
        System.out.println(string);
    }

    public static void printlnError(String string) {
        System.err.println(string);
    }

    public static void println() {
        System.out.println();
    }

    public static enum CustomResults {
        YES,
        NO,
        CANCEL;

    }
}

