/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.controls.JFXSnackbar;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class SettingsController
implements Initializable {
    public Utils utils = new Utils();
    public Label lblContent;
    public JFXButton btnSave;
    public JFXButton btnCancel;
    public BorderPane bpDialog;
    public JFXColorPicker colorPickerSourceNode;
    public JFXColorPicker colorPickerDestinationNode;
    public JFXColorPicker colorPickerGenericNode;
    public JFXColorPicker colorPickerEdge;
    public JFXColorPicker colorPickerWeight;
    public JFXColorPicker colorPickerLabelInsideNode;
    public SharePreferencesHandler sharePreferencesHandler;
    public JFXTextField txtMaxNumSourceNodes;
    public JFXTextField txtMaxNumDestinationNodes;
    public JFXSnackbar jfxSnackbar;
    public AnchorPane anchorDialogContent;
    public JFXColorPicker colorPickerEstimate;
    public JFXToggleButton toggleCompleteSnapshot;
    public JFXToggleButton toggleFringeOrderedByNodeLabelDesc;
    public JFXTextField txtDefaultFolderForImportExport;
    public JFXTextField txtDefaultFolderForSnapshot;
    public JFXTextField txtMinValueForRandomWeight;
    public JFXTextField txtMaxValueForRandomWeight;
    public JFXTextField txtMinValueForRandomEstimate;
    public JFXTextField txtMaxValueForRandomEstimate;
    public JFXToggleButton toggleDuplicateNodesAllowed;
    private boolean confirmed = false;
    private int currentSourceNodeCount = 0;
    private int currentDestinationNodeCount = 0;
    private ResourceBundle resourceBundle;

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
        this.colorPickerSourceNode.setStyle("-fx-color-label-visible: false; -fx-background-radius: 100.0;");
        this.colorPickerDestinationNode.setStyle("-fx-color-label-visible: false; -fx-background-radius: 100.0;");
        this.colorPickerGenericNode.setStyle("-fx-color-label-visible: false; -fx-background-radius: 100.0;");
        this.txtMaxNumSourceNodes.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d{0,1}")) {
                this.txtMaxNumSourceNodes.setText(String.valueOf(this.sharePreferencesHandler.getMaxNumSourceNodes()));
            }
            if (!(newValue.equals("") || Integer.parseInt(newValue) >= this.currentSourceNodeCount && Integer.parseInt(newValue) != 0)) {
                this.jfxSnackbar.show(String.format(this.resourceBundle.getString("text_max_num_source_nodes_greater_than_current"), this.currentSourceNodeCount), 5000L);
                this.txtMaxNumSourceNodes.setText(String.valueOf(this.sharePreferencesHandler.getMaxNumSourceNodes()));
            }
        });
        this.txtMaxNumSourceNodes.setStyle("-fx-alignment: center;");
        this.txtMaxNumDestinationNodes.setStyle("-fx-alignment: center;");
        this.txtMaxNumSourceNodes.setEditable(false);
        this.txtMaxNumSourceNodes.setDisable(true);
        this.txtMaxNumDestinationNodes.setTextFormatter(new TextFormatter(change -> {
            if (!change.getControlNewText().matches("\\d{0,3}")) {
                this.txtMaxNumDestinationNodes.setText(String.valueOf(this.sharePreferencesHandler.getMaxNumDestinationNodes()));
                return null;
            }
            if (!(change.getText().equals("") || Integer.parseInt(change.getText()) >= this.currentDestinationNodeCount && Integer.parseInt(change.getText()) != 0)) {
                this.jfxSnackbar.show(String.format(this.resourceBundle.getString("text_max_num_destination_nodes_greater_than_current"), this.currentDestinationNodeCount), 5000L);
                this.txtMaxNumDestinationNodes.setText(String.valueOf(this.sharePreferencesHandler.getMaxNumDestinationNodes()));
                return null;
            }
            return change;
        }));
        this.txtMaxValueForRandomWeight.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d{0,6}")) {
                Platform.runLater(() -> this.txtMaxValueForRandomWeight.setText(String.valueOf(this.sharePreferencesHandler.getMaxValueForRandomWeight())));
            }
        });
        this.txtMinValueForRandomWeight.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d{0,6}")) {
                Platform.runLater(() -> this.txtMinValueForRandomWeight.setText(String.valueOf(this.sharePreferencesHandler.getMinValueForRandomWeight())));
            }
        });
        this.txtMaxValueForRandomEstimate.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d{0,6}")) {
                Platform.runLater(() -> this.txtMaxValueForRandomEstimate.setText(String.valueOf(this.sharePreferencesHandler.getMaxValueForRandomEstimate())));
            }
        });
        this.txtMinValueForRandomEstimate.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d{0,6}")) {
                Platform.runLater(() -> this.txtMinValueForRandomEstimate.setText(String.valueOf(this.sharePreferencesHandler.getMinValueForRandomEstimate())));
            }
        });
    }

    public void setCurrentSourceNodeCount(int currentSourceNodeCount) {
        this.currentSourceNodeCount = currentSourceNodeCount;
    }

    public void setCurrentDestinationNodeCount(int currentDestinationNodeCount) {
        this.currentDestinationNodeCount = currentDestinationNodeCount;
    }

    public void setSharePreferencesHandles(SharePreferencesHandler sharePreferencesHandler) {
        this.sharePreferencesHandler = sharePreferencesHandler;
    }

    public void populateItems() {
        this.btnSave.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[0]), () -> this.btnSave.fire());
        this.jfxSnackbar = new JFXSnackbar((Pane)this.anchorDialogContent);
        try {
            this.colorPickerSourceNode.setValue(Color.web((String)this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000")));
            this.colorPickerDestinationNode.setValue(Color.web((String)this.sharePreferencesHandler.getColorResource("color_destination_node", "#00c853")));
            this.colorPickerGenericNode.setValue(Color.web((String)this.sharePreferencesHandler.getColorResource("color_generic_node", "#00b8d4")));
            this.colorPickerEdge.setValue(Color.web((String)this.sharePreferencesHandler.getColorResource("color_edge", Utils.toRGBCode(Color.BLUE))));
            this.colorPickerWeight.setValue(Color.web((String)this.sharePreferencesHandler.getColorResource("color_weight", Utils.toRGBCode(Color.BLACK))));
            this.colorPickerEstimate.setValue(Color.web((String)this.sharePreferencesHandler.getColorResource("color_estimate", Utils.toRGBCode(Color.BLACK))));
            this.colorPickerLabelInsideNode.setValue(Color.web((String)this.sharePreferencesHandler.getColorResource("color_label_inside_node", Utils.toRGBCode(Color.WHITE))));
        }
        catch (IllegalArgumentException e) {
            this.jfxSnackbar.show(this.resourceBundle.getString("text_settings_color_something_went_wrong"), 5000L);
        }
        this.txtMaxNumSourceNodes.setText(String.valueOf(this.sharePreferencesHandler.getMaxNumSourceNodes()));
        this.txtMaxNumDestinationNodes.setText(String.valueOf(this.sharePreferencesHandler.getMaxNumDestinationNodes()));
        this.txtMaxValueForRandomWeight.setText(String.valueOf(this.sharePreferencesHandler.getMaxValueForRandomWeight()));
        this.txtMinValueForRandomWeight.setText(String.valueOf(this.sharePreferencesHandler.getMinValueForRandomWeight()));
        this.txtMaxValueForRandomEstimate.setText(String.valueOf(this.sharePreferencesHandler.getMaxValueForRandomEstimate()));
        this.txtMinValueForRandomEstimate.setText(String.valueOf(this.sharePreferencesHandler.getMinValueForRandomEstimate()));
        this.txtDefaultFolderForImportExport.setText(String.valueOf(this.sharePreferencesHandler.getDefaultFolderForImportExport("")));
        this.txtDefaultFolderForSnapshot.setText(String.valueOf(this.sharePreferencesHandler.getDefaultFolderForSnapshot("")));
        this.toggleCompleteSnapshot.setSelected(this.sharePreferencesHandler.getCompleteSnapshot());
        this.toggleFringeOrderedByNodeLabelDesc.setSelected(this.sharePreferencesHandler.isFringeOrderedByNodeLabelDesc());
        this.toggleDuplicateNodesAllowed.setSelected(this.sharePreferencesHandler.isDuplicateNodeCheckingEnabled());
    }

    public void setContent(String text) {
        this.lblContent.setText(text);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    @FXML
    private void handleSaveAction(ActionEvent event) {
        this.confirmed = true;
        int maxNumSourceNodes = -1;
        int maxNumDestinationNodes = -1;
        int maxValueForRandomWeight = -1;
        int minValueForRandomWeight = -1;
        int maxValueForRandomEstimate = -1;
        int minValueForRandomEstimate = -1;
        this.sharePreferencesHandler.setColorResource("color_source_node", Utils.toRGBCode((Color)this.colorPickerSourceNode.getValue()));
        this.sharePreferencesHandler.setColorResource("color_destination_node", Utils.toRGBCode((Color)this.colorPickerDestinationNode.getValue()));
        this.sharePreferencesHandler.setColorResource("color_generic_node", Utils.toRGBCode((Color)this.colorPickerGenericNode.getValue()));
        this.sharePreferencesHandler.setColorResource("color_edge", Utils.toRGBCode((Color)this.colorPickerEdge.getValue()));
        this.sharePreferencesHandler.setColorResource("color_weight", Utils.toRGBCode((Color)this.colorPickerWeight.getValue()));
        this.sharePreferencesHandler.setColorResource("color_estimate", Utils.toRGBCode((Color)this.colorPickerEstimate.getValue()));
        this.sharePreferencesHandler.setColorResource("color_label_inside_node", Utils.toRGBCode((Color)this.colorPickerLabelInsideNode.getValue()));
        this.sharePreferencesHandler.setCompleteSnapshot(this.toggleCompleteSnapshot.isSelected());
        this.sharePreferencesHandler.setFringeOrderedByNodeLabelDesc(this.toggleFringeOrderedByNodeLabelDesc.isSelected());
        this.sharePreferencesHandler.setDuplicateNodeCheckingEnabled(this.toggleDuplicateNodesAllowed.isSelected());
        this.sharePreferencesHandler.setDefaultFolderForImportExport(this.txtDefaultFolderForImportExport.getText());
        this.sharePreferencesHandler.setDefaultFolderForSnapshot(this.txtDefaultFolderForSnapshot.getText());
        if (!this.txtMaxNumSourceNodes.getText().isEmpty()) {
            maxNumSourceNodes = Integer.parseInt(this.txtMaxNumSourceNodes.getText());
            this.sharePreferencesHandler.setMaxNumSourceNodes(maxNumSourceNodes);
        } else {
            this.jfxSnackbar.show(this.resourceBundle.getString("text_max_num_source_nodes_empty"), 2000L);
        }
        if (!this.txtMaxNumDestinationNodes.getText().isEmpty()) {
            maxNumDestinationNodes = Integer.parseInt(this.txtMaxNumDestinationNodes.getText());
            this.sharePreferencesHandler.setMaxNumDestinationNodes(maxNumDestinationNodes);
        } else {
            this.jfxSnackbar.show(this.resourceBundle.getString("text_max_num_destination_nodes_empty"), 2000L);
        }
        if (!this.txtMaxValueForRandomWeight.getText().isEmpty() && !this.txtMinValueForRandomWeight.getText().isEmpty()) {
            maxValueForRandomWeight = Integer.parseInt(this.txtMaxValueForRandomWeight.getText());
            minValueForRandomWeight = Integer.parseInt(this.txtMinValueForRandomWeight.getText());
            if (minValueForRandomWeight <= maxValueForRandomWeight) {
                this.sharePreferencesHandler.setMaxValueForRandomWeight(maxValueForRandomWeight);
                this.sharePreferencesHandler.setMinValueForRandomWeight(minValueForRandomWeight);
            } else {
                maxValueForRandomWeight = -1;
                minValueForRandomWeight = -1;
                this.jfxSnackbar.show(this.resourceBundle.getString("text_min_cannot_be_greater_than_max"), 2000L);
            }
        } else {
            this.jfxSnackbar.show(this.resourceBundle.getString("text_max_and_min_cannot_be_empty"), 2000L);
        }
        if (!this.txtMaxValueForRandomEstimate.getText().isEmpty() && !this.txtMinValueForRandomEstimate.getText().isEmpty()) {
            maxValueForRandomEstimate = Integer.parseInt(this.txtMaxValueForRandomEstimate.getText());
            minValueForRandomEstimate = Integer.parseInt(this.txtMinValueForRandomEstimate.getText());
            if (minValueForRandomEstimate <= maxValueForRandomEstimate) {
                this.sharePreferencesHandler.setMaxValueForRandomEstimate(maxValueForRandomEstimate);
                this.sharePreferencesHandler.setMinValueForRandomEstimate(minValueForRandomEstimate);
            } else {
                maxValueForRandomEstimate = -1;
                minValueForRandomEstimate = -1;
                this.jfxSnackbar.show(this.resourceBundle.getString("text_min_cannot_be_greater_than_max"), 2000L);
            }
        } else {
            this.jfxSnackbar.show(this.resourceBundle.getString("text_max_and_min_cannot_be_empty"), 2000L);
        }
        if (maxNumDestinationNodes != -1 && maxNumSourceNodes != -1 && maxValueForRandomWeight != -1 && minValueForRandomWeight != -1 && maxValueForRandomEstimate != -1 && minValueForRandomEstimate != -1) {
            Node source = (Node)event.getSource();
            Stage stage = (Stage)source.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    private void handleExitAction(ActionEvent event) {
        this.confirmed = false;
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    public void handleChooseDefaultFolderForImportExport(ActionEvent actionEvent) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("text_title_file_chooser_default_folder_for_import_export"));
        Stage stage = new Stage();
        File selectedDirectory = directoryChooser.showDialog((Window)stage);
        if (selectedDirectory != null) {
            String absolutePathDir = selectedDirectory.getAbsolutePath();
            this.txtDefaultFolderForImportExport.setText(absolutePathDir);
        }
    }

    public void handleChooseDefaultFolderForSnapshot(ActionEvent actionEvent) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("text_title_file_chooser_default_folder_for_snapshot"));
        Stage stage = new Stage();
        File selectedDirectory = directoryChooser.showDialog((Window)stage);
        if (selectedDirectory != null) {
            String absolutePathDir = selectedDirectory.getAbsolutePath();
            this.txtDefaultFolderForSnapshot.setText(absolutePathDir);
        }
    }
}

