/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver;

import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import mcgraphresolver.controllers.MainController;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class Main
extends Application {
    public static HostServices hostServices;
    private ClassLoader mainClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private final ObjectProperty<Window> windowOwner = new SimpleObjectProperty();
    private SharePreferencesHandler sharePreferencesHandler;

    public Window getWindowOwner() {
        return (Window)this.windowOwner.get();
    }

    public void setWindowOwner(Window value) {
        this.windowOwner.set((Object)value);
    }

    public ObjectProperty<Window> windowOwnerProperty() {
        return this.windowOwner;
    }

    public void start(final Stage primaryStage) throws Exception {
        System.setProperty("http.agent", "Chrome");
        hostServices = this.getHostServices();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("bundles.strings", Locale.ENGLISH);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getClassLoader().getResource("layouts/layout_main.fxml"), resourceBundle);
        fxmlLoader.setResources(resourceBundle);
        Parent root = (Parent)fxmlLoader.load();
        root.getStylesheets().add((Object)"/css/style.css");
        this.sharePreferencesHandler = new SharePreferencesHandler();
        if (this.sharePreferencesHandler.isFirstLaunch()) {
            this.loadDefaultColor();
            this.sharePreferencesHandler.setFirstLaunch(false);
        }
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        Scene scene = new Scene(root, screenSize.getWidth(), screenSize.getHeight());
        primaryStage.setTitle(resourceBundle.getString("text_title"));
        final MainController mainController = (MainController)fxmlLoader.getController();
        mainController.setStage(primaryStage);
        mainController.populateItems();
        ObservableList stylesheets = scene.getStylesheets();
        stylesheets.addAll((Object[])new String[]{Main.class.getResource("/css/jfoenix-fonts.css").toExternalForm(), Main.class.getResource("/css/jfoenix-design.css").toExternalForm(), Main.class.getResource("/css/style.css").toExternalForm()});
        primaryStage.setScene(scene);
        primaryStage.setMaximized(true);
        primaryStage.getIcons().add((Object)new Image(Main.class.getResourceAsStream("/icons/logo_mc_graph_resolver.png")));
        primaryStage.widthProperty().addListener((observable, oldValue, newValue) -> {
            primaryStage.setWidth(screenSize.getWidth());
            mainController.resizeFxGraph();
        });
        primaryStage.heightProperty().addListener((observable, oldValue, newValue) -> {
            primaryStage.setHeight(screenSize.getHeight());
            mainController.resizeFxGraph();
        });
        Task<Boolean> task = new Task<Boolean>(){

            public Boolean call() {
                primaryStage.show();
                primaryStage.setOnCloseRequest(we -> mainController.saveBeforeClose((WindowEvent)we));
                return true;
            }
        };
        task.setOnSucceeded(e -> Platform.runLater(() -> mainController.resizeFxGraph()));
        new Thread((Runnable)task).run();
    }

    public void loadDefaultColor() {
        this.sharePreferencesHandler.setColorResource("color_source_node", "#d50000");
        this.sharePreferencesHandler.setColorResource("color_destination_node", "#00c853");
        this.sharePreferencesHandler.setColorResource("color_generic_node", "#00b8d4");
        this.sharePreferencesHandler.setColorResource("color_edge", Utils.toRGBCode(Color.BLUE));
        this.sharePreferencesHandler.setColorResource("color_weight", Utils.toRGBCode(Color.BLACK));
        this.sharePreferencesHandler.setColorResource("color_estimate", Utils.toRGBCode(Color.BLACK));
        this.sharePreferencesHandler.setColorResource("color_label_inside_node", Utils.toRGBCode(Color.WHITE));
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

