/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.IterativeDeepeningSearch;
import java.util.List;
import junit.framework.TestCase;

public class IterativeDeepeningSearchTest
extends TestCase {
    public void testIterativeDeepeningSearch() {
        try {
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            IterativeDeepeningSearch search = new IterativeDeepeningSearch();
            SearchAgent agent = new SearchAgent(problem, search);
            List actions2 = agent.getActions();
            this.assertCorrectPlacement(actions2);
            IterativeDeepeningSearchTest.assertEquals("3656", agent.getInstrumentation().getProperty("nodesExpanded"));
        }
        catch (Exception e) {
            IterativeDeepeningSearchTest.fail("Exception should not occur");
        }
    }

    private void assertCorrectPlacement(List actions2) {
        IterativeDeepeningSearchTest.assertEquals(8, actions2.size());
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 0  0", actions2.get(0));
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 1  4", actions2.get(1));
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 2  7", actions2.get(2));
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 3  5", actions2.get(3));
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 4  2", actions2.get(4));
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 5  6", actions2.get(5));
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 6  1", actions2.get(6));
        IterativeDeepeningSearchTest.assertEquals((Object)"placeQueenAt 7  3", actions2.get(7));
    }
}

