/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.GraphSearch;
import aima.search.framework.Search;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.uninformed.UniformCostSearch;
import junit.framework.TestCase;

public class MapAgentTest
extends TestCase {
    ExtendableMap aMap;
    StringBuffer envChanges;

    @Override
    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 5.0);
        this.aMap.addBidirectionalLink("A", "C", 6.0);
        this.aMap.addBidirectionalLink("B", "C", 4.0);
        this.aMap.addBidirectionalLink("C", "D", 7.0);
        this.aMap.addUnidirectionalLink("B", "E", 14.0);
        this.envChanges = new StringBuffer();
    }

    public void testAlreadyAtGoal() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        MapAgent ma = new MapAgent(me, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"A"});
        me.addAgent(ma, "A");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                MapAgentTest.this.envChanges.append(command).append(":");
            }
        });
        me.stepUntilDone();
        MapAgentTest.assertEquals("CurrentLocation=In(A), Goal=In(A):NoOP:METRIC[pathCost]=0.0:METRIC[maxQueueSize]=1:METRIC[queueSize]=0:METRIC[nodesExpanded]=0:NoOP:", this.envChanges.toString());
    }

    public void testNormalSearch() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        MapAgent ma = new MapAgent(me, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"D"});
        me.addAgent(ma, "A");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                MapAgentTest.this.envChanges.append(command).append(":");
            }
        });
        me.stepUntilDone();
        MapAgentTest.assertEquals("CurrentLocation=In(A), Goal=In(D):C:D:METRIC[pathCost]=13.0:METRIC[maxQueueSize]=6:METRIC[queueSize]=1:METRIC[nodesExpanded]=3:NoOP:", this.envChanges.toString());
    }

    public void testNoPath() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        MapAgent ma = new MapAgent(me, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"A"});
        me.addAgent(ma, "E");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                MapAgentTest.this.envChanges.append(command).append(":");
            }
        });
        me.stepUntilDone();
        MapAgentTest.assertEquals("CurrentLocation=In(E), Goal=In(A):NoOP:METRIC[pathCost]=0:METRIC[maxQueueSize]=1:METRIC[queueSize]=0:METRIC[nodesExpanded]=1:NoOP:", this.envChanges.toString());
    }
}

