/*
 * Decompiled with CFR 0.152.
 */
package aima.test.regression.logic.fol;

import aima.logic.fol.inference.FOLTFMResolution;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.trace.FOLTFMResolutionTracer;
import aima.logic.fol.kb.data.Clause;
import aima.test.logictest.foltest.CommonFOLInferenceProcedureTests;
import java.util.Set;

public class FOLTFMResolutionRegression
extends CommonFOLInferenceProcedureTests {
    public void testFullFOLKBLovesAnimalQueryKillsJackTunaFalse() {
        FOLTFMResolution ip = new FOLTFMResolution(1000000L);
        ip.setTracer(new RegressionFOLTFMResolutionTracer());
        this.testFullFOLKBLovesAnimalQueryKillsJackTunaFalse(ip, true);
    }

    private class RegressionFOLTFMResolutionTracer
    implements FOLTFMResolutionTracer {
        private int outerCnt = 1;
        private int noPairsConsidered = 0;
        private int noPairsResolved = 0;
        private int maxClauseSizeSeen = 0;

        private RegressionFOLTFMResolutionTracer() {
        }

        @Override
        public void stepStartWhile(Set<Clause> clauses, int totalNoClauses, int totalNoNewCandidateClauses) {
            this.outerCnt = 1;
            System.out.println("");
            System.out.println("Total # clauses=" + totalNoClauses + ", total # new candidate clauses=" + totalNoNewCandidateClauses);
        }

        @Override
        public void stepOuterFor(Clause i) {
            System.out.print(" " + this.outerCnt);
            if (this.outerCnt % 50 == 0) {
                System.out.println("");
            }
            ++this.outerCnt;
        }

        @Override
        public void stepInnerFor(Clause i, Clause j) {
            ++this.noPairsConsidered;
        }

        @Override
        public void stepResolved(Clause iFactor, Clause jFactor, Set<Clause> resolvents) {
            ++this.noPairsResolved;
            Clause egLargestClause = null;
            for (Clause c : resolvents) {
                if (c.getNumberLiterals() <= this.maxClauseSizeSeen) continue;
                egLargestClause = c;
                this.maxClauseSizeSeen = c.getNumberLiterals();
            }
            if (null != egLargestClause) {
                System.out.println("");
                System.out.println("E.g. largest clause so far=" + this.maxClauseSizeSeen + ", " + egLargestClause);
                System.out.println("i=" + iFactor);
                System.out.println("j=" + jFactor);
            }
        }

        @Override
        public void stepFinished(Set<Clause> clauses, InferenceResult result) {
            System.out.println("Total # Pairs of Clauses Considered:" + this.noPairsConsidered);
            System.out.println("Total # Pairs of Clauses Resolved  :" + this.noPairsResolved);
            this.noPairsConsidered = 0;
            this.noPairsResolved = 0;
            this.maxClauseSizeSeen = 0;
        }
    }
}

