/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probdecisiontest;

import aima.probability.Randomizer;
import aima.probability.decision.MDPTransitionModel;
import aima.probability.decision.MDPUtilityFunction;
import aima.probability.decision.cellworld.CellWorld;
import aima.probability.decision.cellworld.CellWorldPosition;
import aima.test.probabilitytest.MockRandomizer;
import aima.util.Pair;
import junit.framework.TestCase;

public class CellWorldTest
extends TestCase {
    private CellWorld cw;
    private Randomizer alwaysLessThanEightyPercent;
    private Randomizer betweenEightyAndNinetyPercent;
    private Randomizer greaterThanNinetyPercent;

    @Override
    public void setUp() {
        this.cw = new CellWorld(3, 4, -0.04);
        this.cw.markBlocked(2, 2);
        this.cw.setTerminalState(2, 4);
        this.cw.setReward(2, 4, -1.0);
        this.cw.setTerminalState(3, 4);
        this.cw.setReward(3, 4, 1.0);
        this.alwaysLessThanEightyPercent = new MockRandomizer(new double[]{0.7});
        this.betweenEightyAndNinetyPercent = new MockRandomizer(new double[]{0.85});
        this.greaterThanNinetyPercent = new MockRandomizer(new double[]{0.95});
    }

    public void testMoveLeftIntoWallLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 1, "left", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveLeftIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 2, "left", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveLeftIntoUnblockedCellActuallyMovesUpWhenProbabilityBetween80And90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 4, "left", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(4, pos.getY());
    }

    public void testMoveLeftIntoUnblockedCellActuallyMovesDownWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(3, 3, "left", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(3, pos.getY());
    }

    public void testMoveLeftIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(2, 3, "left", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(3, pos.getY());
    }

    public void testMoveRightIntoWallLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 4, "right", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(4, pos.getY());
    }

    public void testMoveRightIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 2, "right", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(3, pos.getY());
    }

    public void testMoveRightIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(2, 1, "right", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveRightIntoUnblockedCellActuallyMovesUpWhenProbabilityBetween80And90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 1, "right", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveRightIntoUnblockedCellActuallyMovesDownWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(3, 3, "right", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(3, pos.getY());
    }

    public void testMoveUpIntoWallLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(3, 1, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(3, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveUpIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 1, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveUpIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 2, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(2, pos.getY());
    }

    public void testMoveUpActuallyMovesLeftWhenProbabilityBetween80And90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 4, "up", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(3, pos.getY());
    }

    public void testMoveUpActuallyMovesRightWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 3, "up", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(4, pos.getY());
    }

    public void testMoveDownIntoWallLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(1, 1, "down", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveDownIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(2, 1, "down", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(1, pos.getX());
        CellWorldTest.assertEquals(1, pos.getY());
    }

    public void testMoveDownIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(3, 2, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(3, pos.getX());
        CellWorldTest.assertEquals(2, pos.getY());
    }

    public void testMoveDownActuallyMovesLeftWhenProbabilityBetween80And90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(3, 3, "down", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals(3, pos.getX());
        CellWorldTest.assertEquals(2, pos.getY());
    }

    public void testMoveDownActuallyMovesRightWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(2, 3, "up", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(4, pos.getY());
    }

    public void testNumberOfUnBlockedCells() {
        CellWorldTest.assertEquals(11, this.cw.unblockedCells().size());
    }

    public void testMoveFromATerminalStateFailsForAllProbabilityValues() {
        CellWorldPosition pos = this.cw.moveProbabilisticallyFrom(2, 4, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals(2, pos.getX());
        CellWorldTest.assertEquals(4, pos.getY());
    }

    public void testTransitionProbabilityCalculationWhenEndingPositionIsNextToStartingPositionButIsBlocked() {
        CellWorldPosition startingPosition = new CellWorldPosition(2, 1);
        CellWorldPosition endingPosition = new CellWorldPosition(2, 2);
        double transitionProb = this.cw.getTransitionProbability(startingPosition, "right", endingPosition);
        CellWorldTest.assertEquals(0.0, transitionProb);
    }

    public void testTransitionProbabilityCalculationWhenEndingPositionCannotBeReachedUsingDesiredActionOrRightAngledSteps() {
        CellWorldPosition startingPosition = new CellWorldPosition(1, 3);
        CellWorldPosition endingPosition = new CellWorldPosition(3, 3);
        double transitionProb = this.cw.getTransitionProbability(startingPosition, "up", endingPosition);
        CellWorldTest.assertEquals(0.0, transitionProb);
    }

    public void testTransitionProbabilityCalculationWhenEndingPositionReachebleByExecutingSuggestedAction() {
        CellWorldPosition startingPosition = new CellWorldPosition(1, 1);
        CellWorldPosition endingPosition = new CellWorldPosition(2, 1);
        double transitionProb = this.cw.getTransitionProbability(startingPosition, "up", endingPosition);
        CellWorldTest.assertEquals(0.8, transitionProb);
    }

    public void testTransitionProbabilityCalculationWhenBothRightAngledActiosnLeadToStartingPosition() {
        CellWorldPosition startingPosition = new CellWorldPosition(2, 1);
        CellWorldPosition endingPosition = new CellWorldPosition(2, 1);
        double transitionProb = this.cw.getTransitionProbability(startingPosition, "up", endingPosition);
        CellWorldTest.assertEquals(0.2, transitionProb);
    }

    public void testTransitionModelCreation() {
        MDPTransitionModel<CellWorldPosition, String> mtm = this.cw.getTransitionModel();
        CellWorldPosition startingPosition = new CellWorldPosition(1, 1);
        CellWorldPosition endingPosition = new CellWorldPosition(2, 1);
        CellWorldTest.assertEquals(0.8, mtm.getTransitionProbability(startingPosition, "up", endingPosition));
        CellWorldPosition endingPosition2 = new CellWorldPosition(1, 1);
        CellWorldTest.assertEquals(0.1, mtm.getTransitionProbability(startingPosition, "up", endingPosition2));
        CellWorldPosition endingPosition3 = new CellWorldPosition(1, 2);
        CellWorldTest.assertEquals(0.1, mtm.getTransitionProbability(startingPosition, "up", endingPosition3));
    }

    public void testCannotTransitionFromFinalState() {
        MDPTransitionModel<CellWorldPosition, String> mtm = this.cw.getTransitionModel();
        CellWorldPosition terminalOne = new CellWorldPosition(2, 4);
        CellWorldPosition terminalTwo = new CellWorldPosition(3, 4);
        CellWorldTest.assertEquals(0.0, mtm.getTransitionProbability(terminalOne, "up", terminalTwo));
        CellWorldTest.assertEquals(0.0, mtm.getTransitionProbability(terminalTwo, "down", terminalOne));
    }

    public void testMaximumTransitionDetection() {
        MDPTransitionModel<CellWorldPosition, String> mtm = this.cw.getTransitionModel();
        MDPUtilityFunction<CellWorldPosition> uf = new MDPUtilityFunction<CellWorldPosition>();
        uf.setUtility(new CellWorldPosition(1, 1), 0.705);
        uf.setUtility(new CellWorldPosition(1, 2), 0.655);
        uf.setUtility(new CellWorldPosition(1, 3), 0.611);
        uf.setUtility(new CellWorldPosition(1, 4), 0.388);
        uf.setUtility(new CellWorldPosition(2, 1), 0.762);
        uf.setUtility(new CellWorldPosition(2, 3), 0.66);
        uf.setUtility(new CellWorldPosition(2, 4), -1.0);
        uf.setUtility(new CellWorldPosition(3, 1), 0.812);
        uf.setUtility(new CellWorldPosition(3, 2), 0.868);
        uf.setUtility(new CellWorldPosition(3, 3), 0.918);
        uf.setUtility(new CellWorldPosition(3, 4), 1.0);
        this.assertPolicyReccomends(this.cw, uf, 1, 1, "up");
        this.assertPolicyReccomends(this.cw, uf, 1, 2, "left");
        this.assertPolicyReccomends(this.cw, uf, 1, 3, "left");
        this.assertPolicyReccomends(this.cw, uf, 1, 4, "left");
        this.assertPolicyReccomends(this.cw, uf, 2, 1, "up");
        this.assertPolicyReccomends(this.cw, uf, 2, 3, "up");
        this.assertPolicyReccomends(this.cw, uf, 2, 4, null);
        this.assertPolicyReccomends(this.cw, uf, 3, 1, "right");
        this.assertPolicyReccomends(this.cw, uf, 3, 2, "right");
        this.assertPolicyReccomends(this.cw, uf, 3, 3, "right");
        this.assertPolicyReccomends(this.cw, uf, 3, 4, null);
    }

    private void assertPolicyReccomends(CellWorld cw, MDPUtilityFunction<CellWorldPosition> uf, int x, int y, String actionExpected) {
        Pair<String, Double> p = cw.getTransitionModel().getTransitionWithMaximumExpectedUtility(new CellWorldPosition(x, y), uf);
        CellWorldTest.assertEquals(actionExpected, p.getFirst());
    }
}

