/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.util.Util;
import java.util.Hashtable;
import junit.framework.TestCase;

public class InformationAndGainTest
extends TestCase {
    public void testInformationCalculation() {
        double[] fairCoinProbabilities = new double[]{0.5, 0.5};
        double[] loadedCoinProbabilities = new double[]{0.01, 0.99};
        InformationAndGainTest.assertEquals(1.0, Util.information(fairCoinProbabilities));
        InformationAndGainTest.assertEquals(0.08079313589591118, Util.information(loadedCoinProbabilities));
    }

    public void testBasicDataSetInformationCalculation() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        double infoForTargetAttribute = ds.getInformationFor();
        InformationAndGainTest.assertEquals(1.0, infoForTargetAttribute);
    }

    public void testDataSetSplit() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        Hashtable<String, DataSet> hash = ds.splitByAttribute("patrons");
        InformationAndGainTest.assertEquals(3, hash.keySet().size());
        InformationAndGainTest.assertEquals(6, hash.get("Full").size());
        InformationAndGainTest.assertEquals(2, hash.get("None").size());
        InformationAndGainTest.assertEquals(4, hash.get("Some").size());
    }

    public void testGainCalculation() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        Hashtable<String, DataSet> hash = ds.splitByAttribute("patrons");
        double gain = ds.calculateGainFor("patrons");
        InformationAndGainTest.assertEquals(0.541, gain, 0.001);
        gain = ds.calculateGainFor("type");
        InformationAndGainTest.assertEquals(0.0, gain, 0.001);
    }
}

