/*
 * Decompiled with CFR 0.152.
 */
package aima.test.coretest;

import aima.basic.Agent;
import aima.basic.MockAgent;
import aima.basic.Wall;
import aima.basic.XYEnvironment;
import aima.basic.XYLocation;
import java.util.ArrayList;
import junit.framework.TestCase;

public class XYEnvironmentTest
extends TestCase {
    XYEnvironment env;
    Agent a;
    private static String LOCATION = XYEnvironment.LOCATION;

    public XYEnvironmentTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.env = new XYEnvironment(10, 12);
        this.a = new MockAgent();
        this.env.addAgent(this.a, new XYLocation(3, 4));
    }

    public void testAddObject() {
        XYEnvironmentTest.assertEquals(1, this.env.getAgents().size());
        XYEnvironmentTest.assertEquals(new XYLocation(3, 4), this.a.getAttribute(LOCATION));
    }

    public void testAddObject2() {
        this.env.addObject(new Wall(), new XYLocation(9, 9));
        XYEnvironmentTest.assertEquals(1, this.env.getAgents().size());
        XYEnvironmentTest.assertEquals(1, this.env.getObjects().size());
        XYEnvironmentTest.assertEquals(1, this.env.getObjectsAt(new XYLocation(9, 9)).size());
    }

    public void testAddObjectTwice() {
        XYEnvironmentTest.assertEquals(1, this.env.getAgents().size());
        XYLocation loc = new XYLocation(5, 5);
        XYLocation loc2 = new XYLocation(6, 6);
        MockAgent b = new MockAgent();
        this.env.addAgent(b, loc);
        XYEnvironmentTest.assertEquals(2, this.env.getAgents().size());
        XYEnvironmentTest.assertEquals(loc, b.getAttribute(LOCATION));
    }

    public void testAbsoluteMoveObject() {
        XYLocation loc = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, loc);
        XYEnvironmentTest.assertEquals(new XYLocation(5, 5), this.a.getAttribute(LOCATION));
    }

    public void testMoveObject() {
        XYLocation loc = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, loc);
        XYEnvironmentTest.assertEquals(new XYLocation(5, 5), this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "North");
        XYEnvironmentTest.assertEquals(new XYLocation(5, 4), this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "East");
        XYEnvironmentTest.assertEquals(new XYLocation(6, 4), this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "South");
        XYEnvironmentTest.assertEquals(new XYLocation(6, 5), this.a.getAttribute(LOCATION));
        this.env.moveObject(this.a, "West");
        XYEnvironmentTest.assertEquals(new XYLocation(5, 5), this.a.getAttribute(LOCATION));
    }

    public void testIsBlocked() {
        XYLocation loc = new XYLocation(5, 5);
        XYEnvironmentTest.assertEquals(0, this.env.getObjectsAt(loc).size());
        XYEnvironmentTest.assertEquals(false, this.env.isBlocked(loc));
        this.env.addObject(new Wall(), loc);
        XYEnvironmentTest.assertEquals(1, this.env.getObjectsAt(loc).size());
        XYEnvironmentTest.assertEquals(true, this.env.isBlocked(loc));
    }

    public void testMoveWithBlockingWalls() {
        XYLocation loc = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, loc);
        XYLocation northLoc = new XYLocation(5, 6);
        XYLocation southLoc = new XYLocation(5, 4);
        XYLocation westLoc = new XYLocation(4, 5);
        this.env.addObject(new Wall(), northLoc);
        XYEnvironmentTest.assertTrue(this.env.isBlocked(northLoc));
        this.env.addObject(new Wall(), southLoc);
        this.env.addObject(new Wall(), westLoc);
        XYEnvironmentTest.assertEquals(3, this.env.getObjects().size());
        this.env.moveObject(this.a, "North");
        this.env.moveObject(this.a, "South");
        this.env.moveObject(this.a, "West");
        this.env.moveObject(this.a, "East");
        XYEnvironmentTest.assertEquals(new XYLocation(6, 5), this.a.getAttribute(LOCATION));
    }

    public void testGetObjectsAt() {
        XYLocation loc = new XYLocation(5, 7);
        this.env.moveObjectToAbsoluteLocation(this.a, loc);
        XYEnvironmentTest.assertEquals(1, this.env.getObjectsAt(loc).size());
        MockAgent b = new MockAgent();
        this.env.addAgent(b, loc);
        XYEnvironmentTest.assertEquals(2, this.env.getObjectsAt(loc).size());
    }

    public void testGetObjectsNear() {
        XYLocation loc = new XYLocation(5, 5);
        this.env.moveObjectToAbsoluteLocation(this.a, loc);
        MockAgent b = new MockAgent();
        MockAgent c = new MockAgent();
        Wall w1 = new Wall();
        this.env.addAgent(b, new XYLocation(7, 4));
        this.env.addAgent(c, new XYLocation(5, 7));
        this.env.addObject(w1, new XYLocation(3, 10));
        ArrayList visibleToA = this.env.getObjectsNear(this.a, 3);
        XYEnvironmentTest.assertEquals(2, visibleToA.size());
        ArrayList visibleToB = this.env.getObjectsNear(b, 3);
        XYEnvironmentTest.assertEquals(1, visibleToB.size());
        this.env.moveObject(b, "North");
        this.env.moveObject(b, "West");
        visibleToB = this.env.getObjectsNear(b, 3);
        XYEnvironmentTest.assertEquals(1, visibleToB.size());
        this.env.moveObjectToAbsoluteLocation(c, new XYLocation(3, 11));
        ArrayList visibleToC = this.env.getObjectsNear(b, 3);
        XYEnvironmentTest.assertEquals(1, visibleToC.size());
    }

    public void testMakePerimeter() {
        this.env.makePerimeter();
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(0, 0)));
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(0, 6)));
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(0, 11)));
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(6, 0)));
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(9, 0)));
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(9, 6)));
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(9, 11)));
        XYEnvironmentTest.assertTrue(this.env.isBlocked(new XYLocation(6, 11)));
    }
}

