/*
 * Decompiled with CFR 0.152.
 */
package aima.search.online;

import aima.basic.Agent;
import aima.basic.Percept;
import aima.search.framework.Problem;
import aima.search.framework.Successor;
import aima.search.online.ActionState;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class LRTAStarAgent
extends Agent {
    private Problem problem;
    private final Hashtable<ActionState, Percept> result = new Hashtable();
    private final Hashtable<Percept, Double> H = new Hashtable();
    private Percept s = null;
    private Object a = null;

    public LRTAStarAgent(Problem problem) {
        this.setProblem(problem);
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
        this.init();
    }

    @Override
    public String execute(Percept sComma) {
        if (!this.goalTest(sComma)) {
            double cost;
            double min;
            if (!this.H.containsKey(sComma)) {
                this.H.put(sComma, this.getProblem().getHeuristicFunction().getHeuristicValue(sComma));
            }
            if (null != this.s) {
                this.result.put(new ActionState(this.a, this.s), sComma);
                min = Double.MAX_VALUE;
                for (Object b : this.actions(this.s)) {
                    cost = this.lrtaCost(this.s, b, this.result.get(new ActionState(b, this.s)));
                    if (!(cost < min)) continue;
                    min = cost;
                }
                this.H.put(this.s, min);
            }
            min = Double.MAX_VALUE;
            this.a = "NoOP";
            for (Object b : this.actions(sComma)) {
                cost = this.lrtaCost(sComma, b, this.result.get(new ActionState(b, sComma)));
                if (!(cost < min)) continue;
                min = cost;
                this.a = b;
            }
        } else {
            this.a = "NoOP";
        }
        this.s = sComma;
        if ("NoOP".equals(this.a)) {
            this.die();
        }
        return this.a.toString();
    }

    private void init() {
        this.live();
        this.result.clear();
        this.H.clear();
        this.s = null;
        this.a = null;
    }

    private boolean goalTest(Percept state) {
        return this.getProblem().isGoalState(state);
    }

    private double lrtaCost(Percept s, Object action, Percept sComma) {
        if (null == sComma) {
            return this.getProblem().getHeuristicFunction().getHeuristicValue(s);
        }
        return this.getProblem().getStepCostFunction().calculateStepCost(s, sComma, action.toString()) + this.H.get(sComma);
    }

    private List<Object> actions(Percept state) {
        ArrayList<Object> actions2 = new ArrayList<Object>();
        List successors = this.getProblem().getSuccessorFunction().getSuccessors(state);
        for (Successor s : successors) {
            actions2.add(s.getAction());
        }
        return actions2;
    }
}

