/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nqueens;

import aima.basic.XYLocation;
import java.util.ArrayList;
import java.util.List;

public class NQueensBoard {
    int[][] board;
    int size;

    public NQueensBoard(int n) {
        this.size = n;
        this.board = new int[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.board[i][j] = 0;
            }
        }
    }

    public void addQueenAt(XYLocation l) {
        if (!this.queenExistsAt(l)) {
            this.board[l.getXCoOrdinate()][l.getYCoOrdinate()] = 1;
        }
    }

    public void removeQueenFrom(XYLocation l) {
        if (this.board[l.getXCoOrdinate()][l.getYCoOrdinate()] == 1) {
            this.board[l.getXCoOrdinate()][l.getYCoOrdinate()] = 0;
        }
    }

    private boolean queenExistsAt(int x, int y) {
        return this.board[x][y] == 1;
    }

    public boolean queenExistsAt(XYLocation l) {
        return this.queenExistsAt(l.getXCoOrdinate(), l.getYCoOrdinate());
    }

    public void moveQueen(XYLocation from, XYLocation to) {
        if (this.queenExistsAt(from) && !this.queenExistsAt(to)) {
            this.removeQueenFrom(from);
            this.addQueenAt(to);
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.board[i][j] = 0;
            }
        }
    }

    public void setBoard(List<XYLocation> al) {
        this.clear();
        for (int i = 0; i < al.size(); ++i) {
            this.addQueenAt(al.get(i));
        }
    }

    public int getNumberOfQueensOnBoard() {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (this.board[i][j] != 1) continue;
                ++count;
            }
        }
        return count;
    }

    public List<XYLocation> getQueenPositions() {
        ArrayList<XYLocation> result = new ArrayList<XYLocation>();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!this.queenExistsAt(i, j)) continue;
                result.add(new XYLocation(i, j));
            }
        }
        return result;
    }

    private boolean isSquareHorizontallyAttacked(int x, int y) {
        return this.numberOfHorizontalAttacksOn(x, y) > 0;
    }

    private boolean isSquareVerticallyAttacked(int x, int y) {
        return this.numberOfVerticalAttacksOn(x, y) > 0;
    }

    private boolean isSquareDiagonallyAttacked(int x, int y) {
        return this.numberOfDiagonalAttacksOn(x, y) > 0;
    }

    public boolean isSquareUnderAttack(XYLocation l) {
        int y;
        int x = l.getXCoOrdinate();
        return this.isSquareHorizontallyAttacked(x, y = l.getYCoOrdinate()) || this.isSquareVerticallyAttacked(x, y) || this.isSquareDiagonallyAttacked(x, y);
    }

    public int getSize() {
        return this.size;
    }

    public void print() {
        System.out.println(this.getBoardPic());
    }

    public String getBoardPic() {
        StringBuffer buffer = new StringBuffer();
        for (int row = 0; row < this.size; ++row) {
            for (int col = 0; col < this.size; ++col) {
                if (this.queenExistsAt(col, row)) {
                    buffer.append(" Q ");
                    continue;
                }
                buffer.append(" - ");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public int getNumberOfAttacksOn(XYLocation l) {
        int x = l.getXCoOrdinate();
        int y = l.getYCoOrdinate();
        return this.numberOfHorizontalAttacksOn(x, y) + this.numberOfVerticalAttacksOn(x, y) + this.numberOfDiagonalAttacksOn(x, y);
    }

    private int numberOfHorizontalAttacksOn(int x, int y) {
        int retVal = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!this.queenExistsAt(i, y) || i == x) continue;
            ++retVal;
        }
        return retVal;
    }

    private int numberOfVerticalAttacksOn(int x, int y) {
        int retVal = 0;
        for (int j = 0; j < this.size; ++j) {
            if (!this.queenExistsAt(x, j) || j == y) continue;
            ++retVal;
        }
        return retVal;
    }

    private int numberOfDiagonalAttacksOn(int x, int y) {
        int j;
        int retVal = 0;
        int i = x + 1;
        for (j = y - 1; i < this.size && j > -1; ++i, --j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        i = x + 1;
        for (j = y + 1; i < this.size && j < this.size; ++i, ++j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        i = x - 1;
        for (j = y - 1; i > -1 && j > -1; --i, --j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        i = x - 1;
        for (j = y + 1; i > -1 && j < this.size; --i, ++j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        return retVal;
    }

    public int hashCode() {
        List<XYLocation> locs = this.getQueenPositions();
        int result = 17;
        for (XYLocation loc : locs) {
            result = 37 * loc.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NQueensBoard aBoard = (NQueensBoard)o;
        boolean retVal = true;
        List<XYLocation> locs = this.getQueenPositions();
        for (XYLocation loc : locs) {
            if (aBoard.queenExistsAt(loc)) continue;
            retVal = false;
        }
        return retVal;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int row = 0; row < this.size; ++row) {
            for (int col = 0; col < this.size; ++col) {
                if (this.queenExistsAt(col, row)) {
                    buf.append('Q');
                    continue;
                }
                buf.append('-');
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

