/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.NodeStore;
import aima.search.framework.Problem;
import aima.search.framework.SearchUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class QueueSearch
extends NodeExpander {
    private static String QUEUE_SIZE = "queueSize";
    private static String MAX_QUEUE_SIZE = "maxQueueSize";
    private static String PATH_COST = "pathCost";

    public List<String> search(Problem problem, NodeStore fringe) {
        this.clearInstrumentation();
        fringe.add(new Node(problem.getInitialState()));
        this.setQueueSize(fringe.size());
        while (!fringe.isEmpty()) {
            Node node = fringe.remove();
            this.setQueueSize(fringe.size());
            if (problem.isGoalState(node.getState())) {
                this.setPathCost(node.getPathCost());
                return SearchUtils.actionsFromNodes(node.getPathFromRoot());
            }
            this.addExpandedNodesToFringe(fringe, node, problem);
            this.setQueueSize(fringe.size());
        }
        return new ArrayList<String>();
    }

    @Override
    public void clearInstrumentation() {
        super.clearInstrumentation();
        this.metrics.set(QUEUE_SIZE, 0);
        this.metrics.set(MAX_QUEUE_SIZE, 0);
        this.metrics.set(PATH_COST, 0);
    }

    public int getQueueSize() {
        return this.metrics.getInt("queueSize");
    }

    public void setQueueSize(int queueSize) {
        this.metrics.set(QUEUE_SIZE, queueSize);
        int maxQSize = this.metrics.getInt(MAX_QUEUE_SIZE);
        if (queueSize > maxQSize) {
            this.metrics.set(MAX_QUEUE_SIZE, queueSize);
        }
    }

    public int getMaxQueueSize() {
        return this.metrics.getInt(MAX_QUEUE_SIZE);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double pathCost) {
        this.metrics.set(PATH_COST, pathCost);
    }

    public abstract void addExpandedNodesToFringe(NodeStore var1, Node var2, Problem var3);
}

