/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.parsing.ast;

import aima.logic.propositional.parsing.PLVisitor;
import aima.logic.propositional.parsing.ast.ComplexSentence;
import aima.logic.propositional.parsing.ast.Sentence;
import java.util.List;

public class MultiSentence
extends ComplexSentence {
    private String operator;
    private List<Sentence> sentences;

    public MultiSentence(String operator, List<Sentence> sentences) {
        this.operator = operator;
        this.sentences = sentences;
    }

    public String getOperator() {
        return this.operator;
    }

    public List getSentences() {
        return this.sentences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSentence sen = (MultiSentence)o;
        return sen.getOperator().equals(this.getOperator()) && sen.getSentences().equals(this.getSentences());
    }

    public int hashCode() {
        int result = 17;
        for (Sentence s : this.sentences) {
            result = 37 * result + s.hashCode();
        }
        return result;
    }

    public String toString() {
        String part1 = "( " + this.getOperator() + " ";
        for (int i = 0; i < this.getSentences().size(); ++i) {
            part1 = part1 + this.sentences.get(i).toString() + " ";
        }
        return part1 + " ) ";
    }

    @Override
    public Object accept(PLVisitor plv, Object arg) {
        return plv.visitMultiSentence(this, arg);
    }
}

