/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;

public class AbstractFOLVisitor
implements FOLVisitor {
    protected Sentence recreate(Object ast) {
        return ((Sentence)ast).copy();
    }

    @Override
    public Object visitVariable(Variable variable, Object arg) {
        return variable.copy();
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable var : sentence.getVariables()) {
            variables.add((Variable)var.accept(this, arg));
        }
        return new QuantifiedSentence(sentence.getQuantifier(), variables, (Sentence)sentence.getQuantified().accept(this, arg));
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object arg) {
        List<Term> terms = predicate.getTerms();
        ArrayList<Term> newTerms = new ArrayList<Term>();
        for (int i = 0; i < terms.size(); ++i) {
            Term t = terms.get(i);
            Term subsTerm = (Term)t.accept(this, arg);
            newTerms.add(subsTerm);
        }
        return new Predicate(predicate.getPredicateName(), newTerms);
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        Term newTerm1 = (Term)equality.getTerm1().accept(this, arg);
        Term newTerm2 = (Term)equality.getTerm2().accept(this, arg);
        return new TermEquality(newTerm1, newTerm2);
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        List<Term> terms = function.getTerms();
        ArrayList<Term> newTerms = new ArrayList<Term>();
        for (int i = 0; i < terms.size(); ++i) {
            Term t = terms.get(i);
            Term subsTerm = (Term)t.accept(this, arg);
            newTerms.add(subsTerm);
        }
        return new Function(function.getFunctionName(), newTerms);
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        return new NotSentence((Sentence)sentence.getNegated().accept(this, arg));
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        Sentence substFirst = (Sentence)sentence.getFirst().accept(this, arg);
        Sentence substSecond = (Sentence)sentence.getSecond().accept(this, arg);
        return new ConnectedSentence(sentence.getConnector(), substFirst, substSecond);
    }
}

