/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.common;

import aima.logic.common.Lexer;
import aima.logic.common.ParseTreeNode;
import aima.logic.common.Token;

public abstract class Parser {
    protected Lexer lexer;
    protected Token[] lookAheadBuffer;
    protected int lookAhead = 3;

    protected void fillLookAheadBuffer() {
        for (int i = 0; i < this.lookAhead; ++i) {
            this.lookAheadBuffer[i] = this.lexer.nextToken();
        }
    }

    protected Token lookAhead(int i) {
        return this.lookAheadBuffer[i - 1];
    }

    protected void consume() {
        this.loadNextTokenFromInput();
    }

    protected void loadNextTokenFromInput() {
        boolean eoiEncountered = false;
        for (int i = 0; i < this.lookAhead - 1; ++i) {
            this.lookAheadBuffer[i] = this.lookAheadBuffer[i + 1];
            if (!this.isEndOfInput(this.lookAheadBuffer[i])) continue;
            eoiEncountered = true;
            break;
        }
        if (!eoiEncountered) {
            try {
                this.lookAheadBuffer[this.lookAhead - 1] = this.lexer.nextToken();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isEndOfInput(Token t) {
        return t.getType() == 9999;
    }

    protected void match(String terminalSymbol) {
        if (!this.lookAhead(1).getText().equals(terminalSymbol)) {
            throw new RuntimeException("Syntax error detected at match. Expected " + terminalSymbol + " but got " + this.lookAhead(1).getText());
        }
        this.consume();
    }

    public abstract ParseTreeNode parse(String var1);
}

